/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application;

import java.util.ArrayList;
import org.jamocha.communication.events.MessageEvent;
import org.jamocha.communication.messagerouter.MessageRouter;
import org.jamocha.communication.messagerouter.StreamChannel;
import org.jamocha.engine.Engine;
import org.jamocha.parser.JamochaValue;

public class Shell {
    public static final String CHANNELNAME = "Shell";
    private MessageRouter router;
    private StreamChannel channel;

    public Shell(Engine engine) {
        this.router = engine.getMessageRouter();
        this.channel = this.router.openChannel(CHANNELNAME, System.in);
    }

    public void run() {
        ArrayList<MessageEvent> msgEvents = new ArrayList<MessageEvent>();
        boolean printPrompt = false;
        System.out.print("Jamocha> ");
        while (true) {
            this.channel.fillEventList(msgEvents);
            if (!msgEvents.isEmpty()) {
                for (MessageEvent event : msgEvents) {
                    String msg;
                    if (event.getType() == MessageEvent.MessageEventType.PARSE_ERROR || event.getType() == MessageEvent.MessageEventType.ERROR || event.getType() == MessageEvent.MessageEventType.RESULT) {
                        printPrompt = true;
                    }
                    if (event.getType() == MessageEvent.MessageEventType.ERROR && (msg = ((Exception)event.getMessage()).getMessage()) != null) {
                        System.out.println(msg.trim());
                    }
                    if (event.getType() == MessageEvent.MessageEventType.COMMAND || event.getMessage().toString().equals("") || event.getMessage().equals(JamochaValue.NIL)) continue;
                    System.out.println(event.getMessage().toString().trim());
                }
                msgEvents.clear();
                if (printPrompt) {
                    System.out.print("Jamocha> ");
                }
                printPrompt = false;
                continue;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

