Imports jade.core
Imports jade.core.behaviours
Imports jade.lang.acl
Imports jade.util
Imports sampleagent

Public Class SampleAgent4
    Inherits Agent

    Public Class State
        Public properties As BasicProperties = Nothing
        Public incoming As ACLMessage = Nothing
        Public gotMessage As Boolean = False
    End Class

    Public st = New State()

    Public Overrides Sub setup()
        Console.WriteLine("Starting agent: " + getLocalName())
        st.properties = New BasicProperties(getArguments())
        Util.parseAgentName(Me, st.properties)
        addBehaviour(New collectMessagesBehaviour(st))
        addBehaviour(New timeoutBehaviour(st))

        Dim msg As ACLMessage = New ACLMessage(ACLMessage.QUERY_REF)
        msg.setContent("ping")
        msg.setSender(getAID())
        Dim pingAgent As AID = New AID("pingAgent@agentcities:1099/JADE", AID.ISGUID)
        pingAgent.addAddresses("http://agentcities.cs.utah.edu:7788/acc")
        msg.addReceiver(pingAgent)
        send(msg)

        If (st.properties.getBooleanProperty("first", False)) Then
            msg = New ACLMessage(ACLMessage.PROPAGATE)
            msg.setContent("0")
            msg.setSender(getAID())
            Dim target As AID = Util.getNextAgent(st.properties)
            msg.addReceiver(target)
            Console.WriteLine(getLocalName() + " >>[" + target.getLocalName() + "]=" + msg.getContent())
            send(msg)
        End If
    End Sub


    Public Class collectMessagesBehaviour
        Inherits CyclicBehaviour

        Dim st As State
        Public Sub New(ByVal aState As State)
            st = aState
        End Sub

        Public Overrides Sub action()
            Dim r As ACLMessage = myAgent.receive()
            If (Not r Is Nothing) Then
                Console.WriteLine(myAgent.getLocalName() + " << [" + r.getSender().getLocalName() + "]=" + r.getContent())
                If (r.getPerformative() = ACLMessage.PROPAGATE) Then
                    st.gotMessage = True
                    st.incoming = r
                End If
            End If
            block(500)
        End Sub
    End Class

    Public Class timeoutBehaviour
        Inherits CyclicBehaviour
        Dim st As State
        Dim count As Integer = 0
        Dim cyclePeriod As Integer = 0
        Dim dueTime As Long = 0
        Public Sub New(ByVal aState As State)
            st = aState
            cyclePeriod = st.properties.getIntProperty("block", 5000)
            dueTime = Util.currentTimeMillis()
        End Sub

        Public Overrides Sub action()
            Dim currentTime As Long = Util.currentTimeMillis()
            If (currentTime + 200 >= dueTime) Then
                count = count + 1
                Console.WriteLine(myAgent.getLocalName() + " wait[" + Format("G", count) + "]")
                If (st.gotMessage) Then
                    st.gotMessage = False
                    st.incoming.setSender(myAgent.getAID())
                    st.incoming.clearAllReceiver()
                    Dim target As AID = Util.getNextAgent(st.properties)
                    st.incoming.addReceiver(target)
                    st.incoming.setContent(java.lang.Integer.toString(java.lang.Integer.parseInt(st.incoming.getContent() + 1)))
                    Console.WriteLine(myAgent.getLocalName() + " >>[" + target.getLocalName() + "]=" + st.incoming.getContent())
                    myAgent.send(st.incoming)
                End If
                block(cyclePeriod)
            Else
                block(dueTime - currentTime)
            End If
        End Sub
    End Class

End Class

