/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/**
 * ***************************************************************
 * JADE - Java Agent DEvelopment Framework is a framework to develop
 * multi-agent systems in compliance with the FIPA specifications.
 * Copyright (C) 2000 CSELT S.p.A.
 * 
 * GNU Lesser General Public License
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation,
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 * **************************************************************
 */
package jade;

import jade.core.Runtime;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.ProfileException;

/**
 * Boots <B><em>JADE</em></b> system
 * 
 * @author Giovanni Caire- TILAB
 * @version $Date: 2002/02/05 14:27:38 $ $Revision: 1.5 $
 * 
 */
public class Boot {
  private static final String DEFAULT_FILENAME = "leap.properties";

  /**
   * Constructor declaration
   */
  private Boot() {
  } 

  /**
   * Starts the JADE runtime system in a J2ME environment
   */
  public static void main(String args[]) {

    try {
      String filename = null;
      if (args.length > 0) {
        filename = args[0];
      } 
      else {
        filename = DEFAULT_FILENAME;
      } 

      ProfileImpl p = new ProfileImpl(filename);

      // small trick - moving much memory consuming instruction to the point where it is not so important
      if (null instanceof jade.lang.acl.ACLMessage) {
        ;
      } 

      System.gc();

      // Start a new JADE runtime system
      Runtime.instance().startUp(p);

      System.gc();
    } 
    catch (ProfileException pe) {
      System.err.println("Error creating Profile ["+pe.getMessage()+"]");
      pe.printStackTrace();
      System.exit(-1);
    } 
  } 

}

