using System;
using jade.core;
using jade.core.behaviours;
using jade.lang.acl;
using jade.util;
using sampleagent;

namespace SampleAgent2
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	public class SampleAgent2:Agent
	{
		static protected BasicProperties properties = null;
		public SampleAgent2() {
		}

		static ACLMessage incoming = null;
		static bool gotMessage = false;

		override public void setup() {
			Console.WriteLine("Starting agent: " + getLocalName());
			properties = new BasicProperties((String [])getArguments());
			Util.parseAgentName(this, properties);
			addBehaviour(new collectMessagesBehaviour()); 
			addBehaviour(new timeoutBehaviour());
						
			ACLMessage msg = new ACLMessage(ACLMessage.QUERY_REF);
			msg.setContent("ping");
			msg.setSender(getAID());
			AID pingAgent = new AID("pingAgent@agentcities:1099/JADE", AID.ISGUID);
			pingAgent.addAddresses("http://agentcities.cs.utah.edu:7788/acc");
			msg.addReceiver(pingAgent);
			send(msg);

			if (properties.getBooleanProperty("first", false)) {
				msg = new ACLMessage(ACLMessage.PROPAGATE);
				msg.setContent("0");
				msg.setSender(getAID());
				AID target = Util.getNextAgent(properties);
				msg.addReceiver(target);
				Console.WriteLine(getLocalName() + " >>[" + target.getLocalName() + "]=" + msg.getContent());
				send(msg);
			}
		}

		public class collectMessagesBehaviour:CyclicBehaviour {
			override public void action () {
				ACLMessage r = myAgent.receive();
				if (r != null) {
					Console.WriteLine(myAgent.getLocalName() + " << [" + r.getSender().getLocalName() + "]=" + r.getContent());
					if (r.getPerformative() == ACLMessage.PROPAGATE) {
						gotMessage = true;
						incoming = r;
					}
				}
				block(500);
			}
		}

		public class timeoutBehaviour:CyclicBehaviour {
			int count = 0;
			int cyclePeriod = properties.getIntProperty("block", 5000);
			long dueTime = Util.currentTimeMillis();
			override public void action () {
				long currentTime = Util.currentTimeMillis();
				if (currentTime + 200 >= dueTime) {
					Console.WriteLine(myAgent.getLocalName() + " wait[" + count++ + "]");
					if (gotMessage) {
						gotMessage = false;
						incoming.setSender(myAgent.getAID());
						incoming.clearAllReceiver();
						AID target = Util.getNextAgent(properties);
						incoming.addReceiver(target);
						incoming.setContent(java.lang.Integer.toString(java.lang.Integer.parseInt(incoming.getContent()) + 1));
						Console.WriteLine(myAgent.getLocalName() + " >>[" + target.getLocalName() + "]=" + incoming.getContent());
						myAgent.send(incoming);
					}
					block(cyclePeriod);
				} else {
					block(dueTime - currentTime);
				}
			}
		}
	}
}