// This is the main DLL file.

#include "stdafx.h"

#include "CPPSampleAgent.h"
#include <iostream>

using namespace std;

namespace CPPSampleAgent
{

	SampleAgent3::SampleAgent3() {
	}

	void SampleAgent3::setup () {
		Console::WriteLine(String::Concat("Starting agent: ", getLocalName()));
		properties = new BasicProperties((String *[])getArguments());
		Util::parseAgentName(this, properties);
		addBehaviour(new collectMessagesBehaviour(this));
		addBehaviour(new timeoutBehaviour(this));

		ACLMessage *msg = new ACLMessage(ACLMessage->QUERY_REF);
		msg->setContent("ping");
		msg->setSender(getAID());
		AID *pingAgent = new AID("pingAgent@agentcities:1099/JADE", AID->ISGUID);
		pingAgent->addAddresses("http://agentcities.cs.utah.edu:7788/acc");
		msg->addReceiver(pingAgent);
		send(msg);

		if (properties->getBooleanProperty("first", false)) {
			msg = new ACLMessage(ACLMessage->PROPAGATE);
			msg->setContent("0");
			msg->setSender(getAID());
			AID *target = Util::getNextAgent(properties);
			msg->addReceiver(target);
			Console::WriteLine(String::Concat(getLocalName(), " >>[", target->getLocalName(), String::Concat("]=", msg->getContent())));
			send(msg);
		}
	}

	collectMessagesBehaviour::collectMessagesBehaviour(SampleAgent3 *myParent) {
		parent = myParent;
	}

	void collectMessagesBehaviour::action () {
		ACLMessage *r = myAgent->receive();
		if (!(r == NULL)) {
			Console::WriteLine(String::Concat(myAgent->getLocalName(), " << [", r->getSender()->getLocalName(), String::Concat("]=", r->getContent())));
			if (r->getPerformative() == ACLMessage->PROPAGATE) {
				parent->gotMessage = true;
				parent->incoming = r;
			}
		}
		block(500);
	}

	timeoutBehaviour::timeoutBehaviour(SampleAgent3 *myParent) {
		count = 0;
		parent = myParent;
		cyclePeriod = parent->properties->getIntProperty("block", 5000);
		dueTime = Util::currentTimeMillis();
	}

	void timeoutBehaviour::action () {
		long currentTime = Util::currentTimeMillis();
		if (currentTime + 200 >= dueTime) {
			if (parent->gotMessage) {
				parent->gotMessage = false;
				parent->incoming->setSender(myAgent->getAID());
				parent->incoming->clearAllReceiver();
				AID *target = Util::getNextAgent(parent->properties);
				(parent->incoming)->addReceiver(target);
				parent->incoming->setContent(java::lang::Integer::toString(java::lang::Integer::parseInt(parent->incoming->getContent()) + 1));
				Console::WriteLine(String::Concat(myAgent->getLocalName(), " >>[", target->getLocalName(), String::Concat("]=", parent->incoming->getContent())));
				myAgent->send(parent->incoming);
			}
			block(cyclePeriod);
		} else {
			block(dueTime - currentTime);
		}
	}
}


