package jadex.util.concurrent;

/**
 *  Interface for the timer that manages future timepoints and has the
 *  task to wakeup agents at the given time entries.
 */
public interface ITimerService
{
	/**
	 *  Add a timing entry.
	 *  @param to The timed obejct to notify.
	 *  @param time	The absolute wakeup time.
	 */
	public void	addEntry(ITimedObject to, long time);
	
	/**
	 *  Remove a timing entry.
	 *  @param agent The agent to notify.
	 */
	public void	removeEntry(ITimedObject to);

	/**
	 *  Called when the platform shuts down.
	 *  Do necessary cleanup here (if any).
	 */
	public void shutdown();
}
