package jadex.tutorial;

import java.io.IOException;
import java.net.*;
import jadex.runtime.*;


/**
 *  The server plan starts a thread to accept
 *  connections from clients.
 */
public class ServerPlanG1 extends Plan	implements Runnable
{
	//-------- attributes --------

	/** The server socket. */
	protected ServerSocket	server;
	
	//-------- constructors --------

	/**
	 *  Create a new plan.
	 */
	public ServerPlanG1(int port)	//throws IOException
	{
		try
		{
			this.server	= new ServerSocket(port);
		}
		catch(IOException e)
		{
			throw new RuntimeException(e.getMessage());
		}
		getLogger().info("Created: "+server);
	}

	//-------- methods --------
	
	/**
	 *  The plan body.
	 *  This method runs on the plan thread.
	 */
	public void body()
	{
		// Start the conmnection listener thread.
		new Thread(this).start();

		// Keep the plan alive and the server is active.
		// When the agent dies the plan will shut down
		// the server in the aborted method.
		// The waitFor will never come back, because the
		// filter matches no event.
		waitFor(IFilter.NEVER);
	}

	/**
	 *  Close server when plan is exited.
	 */
	public void aborted()
	{
		try
		{
			getLogger().info("Closing: "+server);
			server.close();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
	}
	
	/**
	 *  The server code.
	 *  This method runs on the separate thread,
	 *  and repeatedly blocks until a client connects.
	 *  @see Runnable
	 */
	public void	run()
	{
		getExternalAccess().getLogger().info("Created: "+Thread.currentThread());

		// Repeatedly listen for connections, until the server has been closed.
		try
		{
			// Accept connections while server is active.
			while(true)
			{
				Socket	client	= server.accept();
				IGoal goal = getExternalAccess().getGoalbase().createGoal("translate");
				goal.getParameter("client").setValue(client);
				getExternalAccess().getGoalbase().dispatchTopLevelGoal(goal);
			}
		}
		catch(IOException e)
		{
			// Server has been closed.
			getExternalAccess().getLogger().info("Exited: "+Thread.currentThread());
		}
		catch(AgentDeathException e)
		{
			// Agent has died: close server.
			try
			{
				server.close();
			}
			catch(IOException e1)
			{
			}
		}
	}
}
