package jadex.tutorial;

import java.util.StringTokenizer;
import jadex.runtime.*;

/**
 *  Handles all incoming translation requests with
 *  an appropriate subgoal.
 */
public class ProcessTranslationRequestPlanE1 extends Plan
{
	//-------- constructors --------

	/**
	 *  Create a new plan.
	 */
	public ProcessTranslationRequestPlanE1()
	{
		getLogger().info("Created: "+this);
	}

	//-------- methods --------

	/**
	 *  Execute a plan.
	 */
	public void body()
	{
		while(true)
		{
			IMessageEvent me = (IMessageEvent)waitForMessageEvent("request_translation");

			String request = (String)me.getContent();
			StringTokenizer stok	= new StringTokenizer(request, " ");
			int cnttokens = stok.countTokens();

			// Create a translation subgoal.
			if(cnttokens==3)
			{
				String action = stok.nextToken();
				String dir	= stok.nextToken();
				String word = stok.nextToken();
				// Hack!!!

				IGoal goal = createGoal("translate");
				goal.getParameter("direction").setValue(dir);
				goal.getParameter("word").setValue(word);
				try
				{
					dispatchSubgoalAndWait(goal);
					getLogger().info("Translated from "+goal.getName()+" "+
						word+" - "+goal.getParameter("result").getValue());
					//	word+" - "+goal.getResult());
				}
				catch(GoalFailureException e)
				{
					getLogger().info("Word is not in database: "+word);
				};
			}
			else
			{
				getLogger().warning("Request format not correct, needs: #" +
					"action direction word1 [word2]");
			}
		}
	}
}
