package jadex.tutorial;

import javax.swing.*;
import jadex.runtime.*;

/**
 *  The plan for updating the gui.
 */
public class GUIPlanF1 extends Plan
{
	//-------- attributes --------

	/** The gui. */
	protected TranslationGuiF1 gui;

	//-------- constructors --------

	/**
	 *  Create a new plan.
	 */
	public GUIPlanF1()
	{
		getLogger().info("Created: "+this);
		this.gui = new TranslationGuiF1();
	}

	//-------- methods --------

	/**
	 *  The plan body.
	 */
	public void body()
	{
		while(true)
		{
			IInternalEvent event = waitForInternalEvent("gui_update");
			gui.addRow((String[])event.getParameter("content").getValue());
		}
	}

	/**
	 *  The plan was aborted (because of conditional goal
	 *  success or termination from outside).
	 */
	public void aborted()
	{
		SwingUtilities.invokeLater(new Runnable()
		{
			public void run()
			{
				gui.dispose();
			}
		});
	}
}
