package jadex.tutorial;

import java.io.*;
import java.net.Socket;
import jadex.runtime.*;


/**
 *  An english german translation plan can translate
 *  english words to german and is instantiated on demand.
 */
public class EnglishGermanTranslationPlanG1 extends Plan
{
	//-------- attributes --------

	/** Query the tuples for a word. */
	protected IExpression	queryword;

	//-------- constructors --------

	/**
	 *  Create a new plan.
	 */
	public EnglishGermanTranslationPlanG1()
	{
		getLogger().info("Created:"+this);
		this.queryword	= getExpression("query_egword");
	}

	//-------- methods --------

	/**
	 *  The plan body.
	 */
	public void body()
	{
		Socket client = (Socket)getParameter("client").getValue();

		try
		{
			BufferedReader	in	= new BufferedReader(new InputStreamReader(client.getInputStream()));
			String	request	= in.readLine();
			int	slash	= request.indexOf("/");
			int	space	= request.indexOf(" ", slash);
			String	eword	= request.substring(slash+1, space);
			String	gword	= (String)queryword.execute("$eword", eword);
			System.out.println(request);
//			while(request!=null)
//				System.out.println(request	= in.readLine());
			
			PrintStream	out	= new PrintStream(client.getOutputStream());
			out.print("HTTP/1.0 200 OK\r\n");
			out.print("Content-type: text/html\r\n");
			out.println("\r\n");
			out.println("<html><head><title>TranslationM1 - "+eword+"</title></head><body>");
			out.println("<p>Translated from english to german: "+eword+" = "+gword+".");
			out.println("</p></body></html>");
			out.flush();
			client.close();
		}
		catch(IOException e)
		{
			throw new RuntimeException(e.getMessage());
		}
	}
}