package jadex.tools.testcenter;

import jadex.tools.starter.*;

import java.io.File;
import java.io.FileFilter;

/**
 * 
 */
public class TestRootNode extends RootNode
{
	//-------- constructors --------

	/**
	 *  Create a root node for file filter.
	 */
	public TestRootNode(FileFilter filter)
	{
		super(filter);
	}

	
	/**
	 *  Create a new RootNode.
	 *  Bean constructor.
	 */
	public TestRootNode()
	{
	}

	//-------- methods --------

	/**
	 *  Create a node for a given file.
	 */
	protected FileNode createNode(File file)
	{
		FileNode node	= null;

		// Check if entry is file or directory.
		if(file.exists())
		{
			if(file.isDirectory())
			{
				node	= new TestDirNode(this, file);
			}
			else
			{
				node	= new TestJarNode(this, file.getAbsolutePath());
			}
		}
		return node;
	}

	/**
	 *  Return a string representation of this element.
	 */
	public String	toString()
	{
		return "ModelExplorer.root";
	}
}
