package jadex.tools.testcenter;

import jadex.tools.starter.JarNode;
import jadex.util.SGUI;

import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.tree.TreeNode;

/**
 *  A jar node represents a jar file (overrides valid functionality and icons).
 *  todo: is there a better way than copying the whole JarNode
 */
public class TestJarNode extends TestDirNode
{
	//-------- constants --------

	/**
	 * The image  for (m/r) elements.
	 */
	static UIDefaults icons = new UIDefaults(new Object[]
	{
		"src_jar", SGUI.makeIcon(TestJarNode.class, "/jadex/tools/common/images/new_src_jar.png"),
	});

	//-------- constructors --------

	/**
	 *  Create a jar node.
	 */
	public TestJarNode(TreeNode parent, String jar)
	{
		super(parent, new JarNode.JarAsDirectory(jar));
	}

	/**
	 *  Create a jar node.
	 *  Bean constructor.
	 */
	public TestJarNode()
	{
	}

	//-------- methods --------

	/**
	 * @return the icon for this node
	 * @see jadex.tools.starter.FileNode#getIcon()
	 */
	public Icon getIcon()
	{
		if(getParent() instanceof TestRootNode)
		{
			return icons.getIcon("src_jar");
		}

		return super.getIcon();
	}

	/**
	 *  Refresh the node.
	 */
	public boolean refresh()
	{
		if(!(getFile() instanceof JarNode.JarAsDirectory))
		{
			System.err.println(getFile());
		}
		boolean	changed	= ((JarNode.JarAsDirectory)getFile()).refresh();
		if(changed)
		{
			super.refresh();
//			System.out.println("changed "+this);
		}
		return changed;
	}
}

