package jadex.tools.testcenter;

import jadex.tools.starter.*;
import jadex.util.SGUI;

import java.io.File;

import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.tree.TreeNode;

/**
 *  A directory node (overrides valid functionality and icons).
 */
public class TestDirNode extends DirNode
{
	//-------- constants --------

	/**
	 * The image  for (m/r) elements.
	 */
	static UIDefaults icons = new UIDefaults(new Object[]
	{
		"src_folder", SGUI.makeIcon(TestDirNode.class, "/jadex/tools/common/images/new_src_folder.png"),
		"src_folder_testable", SGUI.makeIcon(TestDirNode.class, "/jadex/tools/common/images/new_src_folder_testable.png"),
		"package", SGUI.makeIcon(TestDirNode.class, "/jadex/tools/common/images/new_package.png"),
		"package_testable", SGUI.makeIcon(TestDirNode.class, "/jadex/tools/common/images/new_package_testable.png"),
	});

	//-------- constructors --------

	/**
	 *  Create a test directory node for a given directory.
	 */
	public TestDirNode(TreeNode parent, File dir)
	{
		super(parent, dir);
		setValid(false);
	}

	/**
	 *  Create a test directory node.
	 *  Bean constructor.
	 */
	public TestDirNode()
	{
	}

	//-------- methods --------

	/**
	 *  Return the valid state of the node.
	 */
	public boolean getState()
	{
		return isValid();
	}

	/**
	 *  Check state of directory dependent on state of direct child nodes.
	 */
	protected boolean doCheck()
	{
		boolean	newvalid	= false;
		for(int i=0; !newvalid && i<getChildCount(); i++)
			newvalid	= newvalid || ((FileNode)getChildAt(i)).getState();
							
		// Update valid state.
		boolean	changed	= isValid()!=newvalid;
		if(changed)
			setValid(newvalid);
		return changed;
	}

	/**
	 *  Create a node for a given file.
	 */
	protected TreeNode createNode(File file)
	{
		return file.isDirectory()
			? (TreeNode)new TestDirNode(this, file)
			: (TreeNode)new TestFileNode(this, file);
	}

	/**
	 * @return the icon for this node
	 * @see jadex.tools.starter.FileNode#getIcon()
	 */
	public Icon getIcon()
	{
		Icon	icon	= null;
		if(getParent() instanceof TestRootNode)
		{
			icon	= icons.getIcon(getState()? "src_folder_testable": "src_folder");
		}
		else
		{
			icon	= icons.getIcon(getState()? "package_testable": "package");
		}
		return icon;
	}
}
