package jadex.tools.starter;

import jadex.util.SGUI;

import javax.swing.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import java.awt.*;

/**
 * ModelTreeCellRenderer
 */
public class ModelTreeCellRenderer extends DefaultTreeCellRenderer
{
	//-------- constants --------

	/**
	 * The image  for (m/r) elements.
	 */
	static UIDefaults icons = new UIDefaults(new Object[]
	{
		"agent", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_agent.png"),
		"agent_broken", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_agent_broken.png"),
		"capability", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_capability_small.png"),
		"capability_broken", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_capability_broken.png"),
		"src_folder", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_src_folder.png"),
		"src_folder_broken", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_src_folder_broken.png"),
		"src_jar", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_src_jar.png"),
		"src_jar_broken", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_src_jar_broken.png"),
		"package", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_package.png"),
		"package_broken", SGUI.makeIcon(ModelTreeCellRenderer.class, "/jadex/tools/common/images/new_package_broken.png"),
	});

	//-------- attributes --------

	/**
	 * @param tree
	 * @param value
	 * @param selected
	 * @param expanded
	 * @param leaf
	 * @param row
	 * @param hasFocus
	 */
	public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded,
			boolean leaf, int row, boolean hasFocus)
	{
		Icon icon	= null;
		if(value instanceof IExplorerTreeNode) 
		{
			IExplorerTreeNode	node	= (IExplorerTreeNode)value;
			icon = node.getIcon();
			setToolTipText(node.getToolTipText());
		}
		else
		{
			setToolTipText(value.toString());
		}
		
		if(icon!=null)
		{
			setOpenIcon(icon);			
			setClosedIcon(icon);			
			setLeafIcon(icon);		
		}
		else
		{ // Fallback for unknown elements, should never be called.
			setOpenIcon(UIManager.getIcon("Tree.openIcon"));			
			setClosedIcon(UIManager.getIcon("Tree.closedIcon"));			
			setLeafIcon(UIManager.getIcon("Tree.leafIcon"));			
		}
		
		return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
	}

}
