package jadex.tools.jcc;

import jadex.tools.common.plugin.IControlCenter;
import jadex.tools.common.plugin.IControlCenterPlugin;

import java.util.Properties;

import javax.swing.JMenuBar;
import javax.swing.JToolBar;


/**
 *  Template class for control center plugins.
 */
public abstract class AbstractJCCPlugin implements IControlCenterPlugin
{
	//-------- attributes --------
	
	/** The jcc. */
	protected IControlCenter	jcc;

	//-------- constructors --------
	
	/** 
	 *  Initialize the plugin.
	 */
	public void init(IControlCenter jcc)
	{
		this.jcc	= jcc;
	}
	
	/** 
	 *  Shutdown the plugin.
	 */
	public void shutdown()
	{
	}
	
	//-------- methods --------
	
	/**
	 *  Get the jcc.
	 */
	public IControlCenter	getJCC()
	{
		return this.jcc;
	}

	//-------- empty methods --------
	
	/** 
	 *  Create the tool bar (if any).
	 */
	public JToolBar getToolBar()
	{
		return null;
	}
	
	/** 
	 *  Create the menu bar (if any).
	 */
	public JMenuBar createMenuBar()
	{
		return null;
	}

	/**
	 *  Set properties loaded from project.
	 */
	public void setProperties(Properties ps)
	{
	}

	/**
	 *  Return properties to be saved in project.
	 */
	public void getProperties(Properties ps)
	{
	}

	/**
	 *  Reset the plugin.
	 */
	public void reset()
	{
	}
}
