/*
 * StringArrayRenderer.java
 * Copyright (c) 2005 by University of Hamburg. All Rights Reserved.
 * Departament of Informatics. 
 * Distributed Systems and Information Systems.
 *
 * Created by walczak on Mar 13, 2006.  
 * Last revision $Revision: 4157 $ by:
 * $Author: braubach $ on $Date: 2006-03-29 11:55:08 +0000 (Wed, 29 Mar 2006) $.
 */
package jadex.tools.dfbrowser;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import java.awt.*;

class StringArrayRenderer extends DefaultTableCellRenderer
{

	/**
	 * @param table
	 * @param value
	 * @param isSelected
	 * @param hasFocus
	 * @param row
	 * @param column
	 * @return this
	 * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
	{
		super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
		String[] sa = (String[])value;
		String content;
		String tooltip;
		if(sa == null || sa.length == 0)
		{
			content = "";
			setToolTipText(null);
		}
		else
		{
			content = sa[0];
			tooltip = sa[0];
			for(int i = 1; i < sa.length; i++)
			{
				content += ", " + sa[i];
				tooltip += "<br>" + sa[i];
			}
			setToolTipText("<html>" + tooltip + "</html>");
		}
		setText(content);
		return this;
	}
}

/* 
 * $Log$
 * Revision 1.2  2006/03/29 11:55:08  braubach
 * no message
 *
 * Revision 1.1  2006/03/13 18:19:26  walczak
 * Alpha version of df browser (Mock Up)
 *
 */