/*
 * StringArrayRenderer.java
 * Copyright (c) 2005 by University of Hamburg. All Rights Reserved.
 * Departament of Informatics. 
 * Distributed Systems and Information Systems.
 *
 * Created by walczak on Mar 13, 2006.  
 * Last revision $Revision: 4157 $ by:
 * $Author: braubach $ on $Date: 2006-03-29 11:55:08 +0000 (Wed, 29 Mar 2006) $.
 */
package jadex.tools.dfbrowser;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import java.awt.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

class LeaseTimeRenderer extends DefaultTableCellRenderer
{
	final static DateFormat date_format = new SimpleDateFormat("HH:mm:ss, dd-MM-yyyy");

	/**
	 * @param table
	 * @param value
	 * @param isSelected
	 * @param hasFocus
	 * @param row
	 * @param column
	 * @return this
	 * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
	{
		super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
		Date date = (Date)value;
		String content = "n/a";
		try
		{
			content = date_format.format(date);
		}
		catch(Exception e)
		{/*NOP*/}
		setText(content);
		setToolTipText(content);
		return this;
	}
}