/*
 * DFAgentTable
 */
package jadex.tools.dfbrowser;

import jadex.adapter.fipa.*;
import jadex.tools.common.TableSorter;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;

/**
 *  Table showing the df agent services.
 */
public class DFServiceTable extends JScrollPane
{
	private ServiceTableModel model = new ServiceTableModel();
	private TableSorter sorter = new TableSorter(model);
	private JTable table = new JTable(sorter);

	/**
	 * Constructor for DFAgentTable.
	 */
	public DFServiceTable()
	{
		this.setBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED), "Registered Services"));

		sorter.setTableHeader(table.getTableHeader()); //ADDED THIS
		table.setPreferredScrollableViewportSize(new Dimension(800, 70));
		table.setDefaultRenderer(AgentIdentifier.class, new AgentIdentifierRenderer());
		table.setDefaultRenderer(String[].class, new StringArrayRenderer());
		table.setDefaultRenderer(Property[].class, new PropertyArrayRenderer());
		table.addMouseListener(new MouseAdapter()
		{
			public void mouseClicked(MouseEvent e)
			{
				int selectedRow = table.getSelectedRow();
				if(e.getClickCount() > 1 && selectedRow >= 0)
				{
					int modelRow = sorter.modelIndex(selectedRow);
					//serviceSelected(model.getServiceDescription(modelRow), model.getAgentDescription(modelRow));
				}
			}
		});

		setViewportView(table);
	}

	/**
	 * @param service_description
	 * @param agent_description
	 * /
	protected void serviceSelected(ServiceDescription service_description, AgentDescription agent_description)
	{ 
		// todo?
	}*/

	/**
	 * Sets Agent descriptions for this element
	 *
	 * @param ad
	 */
	public void setAgentDescriptions(AgentDescription[] ad)
	{
		model.setAgentDescriptions(ad);
	}

	/**
	 * @param agentDescription
	 */
	public void setAgentDescription(AgentDescription agentDescription)
	{
		model.setAgentDescription(agentDescription);
	}

	/**
	 * @param props
	 */
	public void getProperties(Properties props)
	{
		TableColumnModel cm = table.getColumnModel();
		for(int i=0; i<cm.getColumnCount(); i++)
		{
			TableColumn column = cm.getColumn(i);
			props.setProperty("serviceTable.column" + i, Integer.toString(column.getWidth()));
		}
	}

	/**
	 * @param props
	 */
	public void setProperties(Properties props)
	{
		TableColumnModel cm = table.getColumnModel();
		for(int i=0; i<cm.getColumnCount(); i++)
		{
			TableColumn column = cm.getColumn(i);
			try
			{
				String p = props.getProperty("serviceTable.column" + i);
				if(p != null)
				{
					column.setPreferredWidth(Integer.parseInt(p));
				}
			}
			catch(Exception e)
			{
			}
		}
	}

}
