package jadex.tools.dfbrowser;

import jadex.adapter.fipa.*;
import jadex.tools.common.TableSorter;

import javax.swing.*;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import java.awt.*;
import java.awt.event.*;
import java.util.*;


/**
 * DFAgentTable
 */
public class DFAgentTable extends JScrollPane
{
	private AgentTableModel model = new AgentTableModel();

	private TableSorter sorter = new TableSorter(model);

	private JTable table = new JTable(sorter);

	protected final JPopupMenu popup;

	/** The browser plugin. */
	protected DFBrowserPlugin browser;

	/**
	 * Constructor for DFAgentTable.
	 */
	public DFAgentTable(final DFBrowserPlugin browser)
	{
		this.browser = browser;
		this.setBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED), "Registered Agent Descriptions"));

		sorter.setTableHeader(table.getTableHeader()); //ADDED THIS
		table.setPreferredScrollableViewportSize(new Dimension(800, 70));
		table.setDefaultRenderer(AgentIdentifier.class, new AgentIdentifierRenderer());
		table.setDefaultRenderer(String[].class, new StringArrayRenderer());
		table.setDefaultRenderer(ServiceDescription[].class, new ServiceDescriptionArrayRenderer());
		table.setDefaultRenderer(Date.class, new LeaseTimeRenderer());
		table.addMouseListener(new MouseAdapter()
		{
			public void mouseClicked(MouseEvent e)
			{
				int selectedRow = table.getSelectedRow();
				if(e.getClickCount() > 1 && selectedRow >= 0)
				{
					agentSelected(model.getAgentDescription(sorter.modelIndex(selectedRow)));
				}
			}

			public void mousePressed(MouseEvent e)
			{
				if(e.isPopupTrigger())
				{
					showPopUp(e.getX(), e.getY());
				}
			}

			public void mouseReleased(MouseEvent e)
			{
				if(e.isPopupTrigger())
				{
					showPopUp(e.getX(), e.getY());
				}
			}
		});

		setViewportView(table);
		popup = new JPopupMenu();
		addMenuItems(popup);
	}

	/**
	 * @param menu
	 */
	protected void addMenuItems(JPopupMenu menu)
	{
		menu.add(new JMenuItem(new AbstractAction("Remove agent description")
		{
			public void actionPerformed(ActionEvent e)
			{
				int selectedRow = table.getSelectedRow();
				if(selectedRow >= 0)
				{
					browser.removeAgentRegistration(model.getAgentDescription(sorter.modelIndex(selectedRow)));
				}
			}

		}));
		menu.add(new JMenuItem(new AbstractAction("Show services")
		{
			public void actionPerformed(ActionEvent e)
			{
				int selectedRow = table.getSelectedRow();
				if(selectedRow >= 0)
				{
					agentSelected(model.getAgentDescription(sorter.modelIndex(selectedRow)));
				}
			}
		}));
	}

	/**
	 * shows popup
	 * @param x
	 * @param y
	 */
	protected void showPopUp(int x, int y)
	{
		popup.show(this, x, y);
	}

	/**
	 * @param agentDescription
	 */
	protected void agentSelected(AgentDescription agentDescription)
	{ // nop
	}


	static final AgentDescription[] EMPTY = new AgentDescription[0];

	/**
	 * @return the descriptions of selected agents
	 */
	public AgentDescription[] getSelectedAgents()
	{
		int count = table.getSelectedRowCount();
		if(count == 0)
		{
			return EMPTY;
		}
		ArrayList sa = new ArrayList();
		int[] rows = table.getSelectedRows();
		for(int i = 0; i < rows.length; i++)
		{
			sa.add(model.getAgentDescription(sorter.modelIndex(rows[i])));
		}

		return (AgentDescription[])sa.toArray(new AgentDescription[sa.size()]);
	}

	/**
	 * Sets Agent descriptions for this element
	 *
	 * @param ad
	 */
	public void setAgentDescriptions(AgentDescription[] ad)
	{
		model.setAgentDescriptions(ad);
	}

	/**
	 * @param props
	 */
	public void getProperties(Properties props)
	{
		TableColumnModel cm = table.getColumnModel();
		int cc = cm.getColumnCount();
		while(cc > 0)
		{
			TableColumn column = cm.getColumn(--cc);
			props.setProperty("agentTable.column" + cc, Integer.toString(column.getWidth()));
		}
	}

	/**
	 * @param props
	 */
	public void setProperties(Properties props)
	{
		TableColumnModel cm = table.getColumnModel();
		int cc = cm.getColumnCount();
		while(cc > 0)
		{
			TableColumn column = cm.getColumn(--cc);
			try
			{
				String p = props.getProperty("agentTable.column" + cc);
				if(p != null)
				{
					column.setPreferredWidth(Integer.parseInt(p));
				}
			}
			catch(Exception e)
			{
			}
		}
	}
}
