/*
 * AgentIdentifierRenderer.java
 * Copyright (c) 2005 by University of Hamburg. All Rights Reserved.
 * Departament of Informatics. 
 * Distributed Systems and Information Systems.
 *
 * Created by walczak on Mar 13, 2006.  
 * Last revision $Revision: 4157 $ by:
 * $Author: braubach $ on $Date: 2006-03-29 11:55:08 +0000 (Wed, 29 Mar 2006) $.
 */
package jadex.tools.dfbrowser;

import jadex.adapter.fipa.AgentIdentifier;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import java.awt.*;

class AgentIdentifierRenderer extends DefaultTableCellRenderer
{

	/**
	 * @param table
	 * @param value
	 * @param isSelected
	 * @param hasFocus
	 * @param row
	 * @param column
	 * @return this
	 * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
	{
		super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
		AgentIdentifier aid = (AgentIdentifier)value;
		setText(aid.getName());
		String[] addresses = aid.getAddresses();
		String tooltip = aid.getName();
		for(int i = 0; i < addresses.length; i++)
		{
			tooltip += "<br>" + addresses[i];
		}
		setToolTipText("<html>" + tooltip + "</html>");
		return this;
	}
}
