package jadex.tools.common;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.SFipa;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;
import jadex.tools.ontology.Deregister;
import jadex.tools.ontology.Register;
import jadex.tools.ontology.ToolRequest;


/**
 *  Plan to issue a request to an observed agent.
 */
public class ToolRequestPlan extends Plan
{
	//-------- attributes --------

	/** The tool. */
	protected IToolPanel	tool;

	/** The observed agent. */
	protected AgentIdentifier	agent;

	/** The request. */
	protected ToolRequest	request;

	//-------- constructors --------
	
	/**
	 *  Create a new ToolRequestPlan.
	 */
	public ToolRequestPlan(IToolPanel tool, AgentIdentifier agent, ToolRequest request)
	{
		this.tool	= tool;
		this.agent	= agent;
		this.request	= request;
	}

	//-------- methods --------
	
	/**
	 *  Plan body.
	 */
	public void body()
	{
		// Create request message.
		// Using reply-with assures that this plan will get the answer
		// (and not the update plan, which only waits for the conversation id).
		IMessageEvent	request_msg	= createMessageEvent("tool_request");
		request_msg.getParameterSet(SFipa.RECEIVERS).addValue(agent);
		request_msg.getParameter(SFipa.REPLY_WITH).setValue(SFipa.createUniqueId(tool.getId()));
		request_msg.getParameter(SFipa.CONVERSATION_ID).setValue(tool.getId());
		request_msg.setContent(request);

		long timeout = ((Long)getBeliefbase().getBelief("timeout").getFact()).longValue();
		IMessageEvent	reply	= sendMessageAndWait(request_msg, timeout);
		getRootGoal().setResult(reply.getContent());

		if(reply.getType().equals("tool_failure"))
			fail();
	}
}
