/*
 * SelectAction.java
 * Copyright (c) 2005 by University of Hamburg. All Rights Reserved.
 * Departament of Informatics. 
 * Distributed Systems and Information Systems.
 *
 * Created by 9walczak on Jan 25, 2005.  
 * Last revision $Revision: 4071 $ by:
 * $Author: walczak $ on $Date: 2006-03-14 11:58:00 +0000 (Tue, 14 Mar 2006) $.
 */
package jadex.tools.common;

import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;

/** 
 * <code>SelectAction</code>
 * @since Jan 25, 2005
 */
public class SelectAction
{
  /** <code>flag</code>: the flag for this action */
  protected boolean              flag = false;

  /** <code>action</code>: an action */
  protected final AbstractAction action;

  /** 
   * Constructor: <code>SelectAction</code>.
   * 
   * @param name
   */
  public SelectAction(String name)
  {
    this(name, null);
  }

  /** 
   * Constructor: <code>SelectAction</code>.
   * 
   * @param name
   * @param icon
   */
  public SelectAction(String name, Icon icon)
  {
    action = new AbstractAction(name, icon)
    {
      /** 
       * @param e 
       * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
       */
      public void actionPerformed(ActionEvent e)
      {
        AbstractButton cb = (AbstractButton)e.getSource();
        setSelected(cb.isSelected());
      }
    };
  }

  /**  
   * @param b
   */
  public void setSelected(boolean b)
  {
    if (flag!=b)
    {
      synchronized(this)
      {
        flag = b;
        int i = buttons.size();
        while(i-->0)
        {
          AbstractButton ab = (AbstractButton)buttons.get(i);
          if (ab.isSelected()!=flag)
          {
            ab.setSelected(flag);
          }
        }
      } 

      flagChanged(flag);
    }
  }

  /** 
   * @return true if this action is selected
   */
  public boolean isSelected()
  {
    return flag;
  }

  /** no op. called when the flag has changed
   * @param flag
   */
  public void flagChanged(boolean flag)
  { /* no op */}

  /** <code>buttons</code>: stores the buttons to be notified */
  protected final ArrayList buttons = new ArrayList();

  /** adds a button 
   * @param ab
   * @return the argument 
   */
  public synchronized AbstractButton add(AbstractButton ab)
  {
    if ( !buttons.contains(ab))
    {
      buttons.add(ab);
    }
    ab.setAction(action);
    return ab;
  }

  /**
   * @return a new fresh JCheckBoxMenuItem
   */
  public JCheckBoxMenuItem getCBItem()
  {
    return (JCheckBoxMenuItem)add(new JCheckBoxMenuItem());
  }

}

/*  
 * $Log$
 * Revision 1.1  2006/03/14 11:58:00  walczak
 * finished the DF Browser
 *
 * Revision 1.1  2005/08/02 15:13:11  braubach
 * alpha version of new platform independent tracer
 *
 * Revision 1.1  2005/04/26 13:45:50  pokahr
 * *** empty log message ***
 *
 * Revision 1.4  2005/03/17 15:08:19  9walczak
 * Tested for multithreading. Major fixes.
 *
 * Revision 1.3  2005/02/05 22:03:41  9walczak
 * Created new Ontology. Removed sync methods.
 * Made all filters positive. User may specify filter from the gui.
 * Many fixes.
 *
 * Revision 1.2  2005/01/27 12:29:42  9walczak
 * Added a negative filter in the tracer agent.
 * Made the filter at TracerPreprocessor positive.
 *
 * Revision 1.1  2005/01/26 13:47:29  9walczak
 * Beta release. Many fixes.
 *
 */