package jadex.tools.common;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import jadex.util.*;

/**
 * Button to start a web browser showing the Jadex Home page.
 */
public class JadexLogoButton extends JButton
{
	private static UIDefaults icons = new UIDefaults(new Object[]
	{
		"JadexLogo", SGUI.makeIcon(JadexLogoButton.class, "/jadex/tools/common/images/jadexlogo.png"),
		"JadexLogoV", SGUI.makeIcon(JadexLogoButton.class, "/jadex/tools/common/images/jadexlogoV.png"),
	});

	private final JToolBar tb;
	private int last_orient;

	/**
	 * Constructor for JadexLogoButton.
	 * @param tb
	 */
	public JadexLogoButton(final JToolBar tb)
	{
		super(icons.getIcon("JadexLogo"));
		this.tb = tb;
		setBorder(BorderFactory.createRaisedBevelBorder());
//      setMargin(new Insets(1,1,1,1));
		setToolTipText("Go to Jadex Home Page");
		addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				try
				{
					BrowserLauncher2.openURL("http://vsis-www.informatik.uni-hamburg.de/projects/jadex");
				}
				catch(java.io.IOException ex)
				{
					String txt = SUtil.wrapText("Could not open URL in browser\n\n"+ex.getMessage());
					JOptionPane.showMessageDialog(SGUI.getWindowParent(tb), txt, "Browser Error", JOptionPane.ERROR_MESSAGE);
					//ex.printStackTrace();
				}
			}
		});
		last_orient = tb.getOrientation();
	}


	/**
	 * @return
	 * @see java.awt.Component#getPreferredSize()
	 */
	public Dimension getPreferredSize()
	{
		int orient = tb.getOrientation();
		if(orient!=last_orient)
		{
			switch(tb.getOrientation())
			{
				case JToolBar.HORIZONTAL:
					setIcon(icons.getIcon("JadexLogo"));
					break;
				case JToolBar.VERTICAL:
					setIcon(icons.getIcon("JadexLogoV"));
			}
			last_orient = orient;
		}

		return super.getPreferredSize();
	}
}