package jadex.testcases.goals;

import jadex.planlib.TestReport;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;

/**
 *  Create a goal and wait for the result.
 */
public class GenerateGoalPlan extends Plan
{
	public void body()
	{
		TestReport	report	= new TestReport("test_goal", "Dispatch a goal and wait for the result");
		try
		{
			IGoal	agoal	= createGoal("testgoal");
			
			// If "param" is present set to "foo".
			if(agoal.hasParameter("param"))
				agoal.getParameter("param").setValue("foo");

			dispatchSubgoalAndWait(agoal);

			// If "result" is present check for "foo".
			if(!agoal.hasParameter("result") || "foo".equals(agoal.getParameter("result").getValue()))
				report.setSucceeded(true);
			else
				report.setReason("Wrong result value: "+agoal.getParameter("result").getValue());
		}
		catch(GoalFailureException gfe)
		{
			report.setReason(gfe.toString());
		}
		getBeliefbase().getBeliefSet("reports").addFact(report);
	}
}
