package jadex.testcases.events;

import java.util.List;
import java.util.Map;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.planlib.*;
import jadex.runtime.*;
import jadex.testcases.AbstractMultipleAgentsPlan;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;

/**
 *  Test different protocol goals.
 */
public class ProtocolTestPlan extends AbstractMultipleAgentsPlan
{
	/**
	 * The body method is called on the
	 * instatiated plan instance from the scheduler.
	 */
	public void body()
	{
		// Create 2 participants
		Map[] args = new Map[2];
		List agents = createAgents("jadex.testcases.events.ProtocolReceiver", args);	

		TestReport tr = new TestReport("#1", "Test request protocol.");
		if(assureTest(tr))
		{
			try
			{
				IGoal request = createGoal("rp_initiate");
				request.getParameter("content").setValue("Request a task.");
				request.getParameter("receiver").setValue(agents.get(0));
				dispatchSubgoalAndWait(request);
				getLogger().info("Request result:"+request.getParameter("result").getValue());
				tr.setSucceeded(true);
			}
			catch(GoalFailureException e)
			{
				tr.setFailed("Exception occurred: "+e);
			}
		}
		getBeliefbase().getBeliefSet("reports").addFact(tr);

		tr = new TestReport("#2", "Test cnp protocol.");
		if(assureTest(tr))
		{
			try
			{
				IGoal cnpini = createGoal("cnp_initiate");
				cnpini.getParameterSet("receivers").addValues(agents.toArray(new AgentIdentifier[agents.size()]));
				cnpini.getParameter("content").setValue("CFP for a task.");
				cnpini.getParameter("selector").setValue(new Selector(Selector.ALL));
				dispatchSubgoalAndWait(cnpini);
				getLogger().info("CFP result:"+ SUtil.arrayToString(cnpini.getParameterSet("result").getValues()));
				tr.setSucceeded(true);
			}
			catch(GoalFailureException e)
			{
				tr.setFailed("Exception occurred: "+e);
			}
		}
		getBeliefbase().getBeliefSet("reports").addFact(tr);

		tr = new TestReport("#3", "Test iterated-cnp protocol.");
		if(assureTest(tr))
		{
			try
			{
				IGoal cnpini = createGoal("cnp_initiate");
				cnpini.getParameterSet("receivers").addValues(agents.toArray(new AgentIdentifier[agents.size()]));
				cnpini.getParameter("content").setValue("CFP for a task.");
				cnpini.getParameter("selector").setValue(new Selector(null, Selector.ALL)
				{
					int cnt = 0;
					protected Object[] determineAcceptableProposals(Object[] proposals)
					{
						Object[] ret = new Object[0];
						cnt++;
						if(cnt==3)
							ret = proposals;
						return ret;
					}
	
				});
				cnpini.getParameter("iteration_decider").setValue(new IterationDecider(3));
				dispatchSubgoalAndWait(cnpini);
				getLogger().info("CFP result:"+ SUtil.arrayToString(cnpini.getParameterSet("result").getValues()));
				tr.setSucceeded(true);
			}
			catch(GoalFailureException e)
			{
				tr.setFailed("Exception occurred: "+e);
			}
		}
		
		getBeliefbase().getBeliefSet("reports").addFact(tr);
	}
}
