package jadex.runtime;

import jadex.util.Tuple;
import jadex.model.IMExpression;


/**
 *  The common interface for expressions.
 */
public interface IExpression extends IElement
{
	//-------- methods --------

	/**
	 *  Evaluate the expression.
	 *  @return	The value of the expression.
	 */
	public Object getValue();

	/**
	 *  Refresh the cached expression value.
	 */
	public void refresh();

	//-------- expression parameters --------

	/**
	 *  Set an expression parameter.
	 *  @param name The parameter name.
	 *  @param value The parameter value.
	 */
	public void setParameter(String name, Object value);

	/**
	 *  Get an expression parameter.
	 *  @param name The parameter name.
	 *  @return The parameter value.
	 */
	public Object getParameter(String name);

	//-------- IQuery methods --------

	/**
	 *  Execute the query.
	 *  @return the result value of the query.
	 */
	public Object	execute();

	/**
	 *  Execute the query using a local parameter.
	 *  @param name The name of the local parameter.
	 *  @param value The value of the local parameter.
	 *  @return the result value of the query.
	 */
	public Object	execute(String name, Object value);

	/**
	 *  Execute the query using local parameters.
	 *  @param parameters The local parameters (array of name-value pairs).
	 *  @return the result value of the query.
	 */
	public Object	execute(Tuple[] parameters);
}