package jadex.runtime;

import jadex.model.IMEvent;
import jadex.model.IMEventReference;


/**
 *  Interface for an event base.
 */
public interface IEventbase extends IElement
{
	//-------- attributes --------

	/**
	 *  Send a message after some delay.
	 *  @param me	The message event.
	 *  @return The filter to wait for an answer.
	 */
	public IFilter	sendMessage(IMessageEvent me);

	/**
	 *  Dispatch an event.
	 *  @param event The event.
	 */
	public void dispatchInternalEvent(IInternalEvent event);

	/**
	 *  Create a new message event.
	 *  @return The new message event.
	 */
	public IMessageEvent createMessageEvent(String type);


	/**
	 *  Create a new intenal event.
	 *  @return The new intenal event.
	 */
	public IInternalEvent createInternalEvent(String type);

	/**
	 *  Create a legacy internal event (not explicitly defined in ADF).
	 *  @return The new internal event.
	 *  @deprecated Convenience method for easy conversion to the new Jadex version.
	 *  Will be removed in later releases.
	 */
	public IInternalEvent createInternalEvent(String type, Object content);

	/**
	 *  Register a new event model.
	 *  @param mevent The event model.
	 */
	public void registerEvent(IMEvent mevent);

	/**
	 *  Register a new event reference model.
	 *  @param meventref The event reference model.
	 */
	public void registerEventReference(IMEventReference meventref);

	/**
	 *  Deregister an event model.
	 *  @param mevent The event model.
	 */
	public void deregisterEvent(IMEvent mevent);

	/**
	 *  Deregister an event reference model.
	 *  @param meventref The event reference model.
	 */
	public void deregisterEventReference(IMEventReference meventref);
	
	
	//-------- listeners --------

	/**
	 *  Add a internal event listener.
	 *  @param type	The internal event type.
	 *  @param listener The internal event listener.
	 *  @param async True, if the notification should be done on a separate thread.
	 */
	public void addInternalEventListener(String type, IInternalEventListener userlistener, boolean async);
	
	/**
	 *  Remove a internal event listener.
	 *  @param type	The internal event type.
	 *  @param listener The internal event listener.
	 */
	public void removeInternalEventListener(String type, IInternalEventListener userlistener);
	
	/**
	 *  Add a message event listener.
	 *  @param type	The message event type.
	 *  @param listener The message event listener.
	 *  @param async True, if the notification should be done on a separate thread.
	 */
	public void addMessageEventListener(String type, IMessageEventListener userlistener, boolean async);
	
	/**
	 *  Remove a message event listener.
	 *  @param type	The message event type.
	 *  @param listener The message event listener.
	 */
	public void removeMessageEventListener(String type, IMessageEventListener userlistener);
}
