package jadex.runtime;

/**
 *  The info objects for plan candidates.
 */
public interface ICandidateInfo
{
	/**
	 *  Get the plan instance.
	 *  @param caller The caller (plan or other object).
	 *  @return	The plan instance.
	 */
	public IPlan getPlan(Object caller);

	/**
	 *  Get the associated event.
	 *  @param caller The caller (plan or other object).
	 *  @return	The associated event.
	 */
	public IEvent	getEvent(Object caller);

}
