package jadex.planlib;

import jadex.runtime.*;

/**
 *  Receive a request and answer it.
 */
public class RPReceiverPlan extends Plan
{
	/**
	 *  The body method is called on the
	 *  instatiated plan instance from the scheduler.
	 */
	public void body()
	{
		IMessageEvent me = (IMessageEvent)getInitialEvent();
		getLogger().info("Receiver got request: "+me);
		IMessageEvent reply;

		try
		{
			Boolean res = decideRequest(me.getContent());

			if(res!=null)
			{
				if(res.booleanValue())
				{
					getLogger().info("Receiver sent agree.");
					reply = me.createReply("rp_agree");
					sendMessage(reply);
				}
				else
				{
					getLogger().info("Receiver sent refuse.");
					reply = me.createReply("rp_refuse");
					sendMessage(reply);
					return;
				}
			}
		}
		catch(GoalFailureException e)
		//catch(Exception e)
		{
			getLogger().info("No agree/refuse sent.");
			//e.printStackTrace();
		}

		try
		{
			Object res = executeRequest(me.getContent());
			reply = me.createReply("rp_inform_done");
			reply.setContent(res);
			getLogger().info("Receiver sent inform done.");
			sendMessage(reply);
		}
		//catch(Exception e)
		catch(GoalFailureException e)
		{
			getLogger().info("Receiver sent failure: "+e);
			reply = me.createReply("rp_failure");
			sendMessage(reply);
		}
	}

	/**
	 *  Decide about the request.
	 *  @param request The request.
	 *  @return True, if should send agree. False for sending refuse. Exception/null for sending nothing.
	 */
	public Boolean decideRequest(Object request)
	{
		IGoal decide_request = createGoal("rp_decide_request");
		decide_request.getParameter("request").setValue(request);
		dispatchSubgoalAndWait(decide_request);
		return (Boolean)decide_request.getParameter("result").getValue();
	}

	/**
	 *  Execute the request.
	 *  @param request The request.
	 *  @return The result.
	 */
	public Object executeRequest(Object request)
	{
		IGoal execute_request = createGoal("rp_execute_request");
		execute_request.getParameter("request").setValue(request);
		dispatchSubgoalAndWait(execute_request);
		return execute_request.getParameter("result").getValue();
	}
}
