package jadex.planlib;

import jadex.adapter.fipa.AgentIdentifier;

import java.util.*;

/**
 *  Default selector implementation for evaluating a set of proposals.
 */
public class IterationDecider implements IIterationDecider
{
	//-------- constants --------

	/** The constant for specifiying that any number of negotiation round are ok. */
	public static final int UNRESTRICTED = -1;

	//-------- variables --------

	/** The max number of iterations. */
	protected int max_iters;

	//-------- constructors --------

	/**
	 *  Create a new iteration decider.
	 *  @param max_iters The maximum number of iterations.
	 */
	public IterationDecider(int max_iters)
	{
		this.max_iters = max_iters;
	}

	//-------- methods --------

	/**
	 *  Decide about a new negotiation round.
	 *  @param records The negotiation records.
	 *  @return The next round participants.
	 */
	public AgentIdentifier[] decideIteration(NegotiationRecord[] records)
	{
		List ret = new ArrayList();
		NegotiationRecord nr = records[records.length-1];
		Object[] acc_proposals = nr.getAcceptableProposals();
		if(acc_proposals.length==0 && records.length<max_iters)
		{
			Object[] proposals = nr.getProposals();
			for(int i=0; i<proposals.length; i++)
				ret.add(nr.getAgentIdentifier(proposals[i]));
		}
		return (AgentIdentifier[])ret.toArray(new AgentIdentifier[ret.size()]);
	}

	/**
	 *  Refine the cfp.
	 *  @param records The negotiation records.
	 *  @return The refined cfp.
	 */
	public Object refineCFP(NegotiationRecord[] records)
	{
		return records[records.length-1].getCFP();
	}
}

