package jadex.planlib;

import jadex.adapter.fipa.AgentIdentifier;

/**
 *  Interface for a component that decides if a further negotiation
 *  round is needed in the iterated contract net.
 */
public interface IIterationDecider
{
	/**
	 *  Decide about a new negotiation round.
	 *  @param records The negotiation records.
	 *  @return The next round participants.
	 */
	public AgentIdentifier[] decideIteration(NegotiationRecord[] records);

	/**
	 *  Refine the call for proposal on basis of the last
	 *  negotiation rounds.
	 *  @param records The negotiation records.
	 *  @return The refined cfp.
	 */
	public Object refineCFP(NegotiationRecord[] records);
}
