package jadex.planlib;

import jadex.runtime.*;
import jadex.util.collection.SCollection;

import java.util.List;

/**
 *  Receive a contract net protocol (cnp) and answer it.
 */
public class CNPReceiverPlan extends Plan
{
	/**
	 *  The body method is called on the
	 *  instatiated plan instance from the scheduler.
	 */
	public void body()
	{
		long timeout;
		if(getBeliefbase().containsBelief("timeout") && getBeliefbase().getBelief("timeout").getFact()!=null)
		{
			timeout = ((Long)getBeliefbase().getBelief("timeout").getFact()).longValue();
		}
		else
		{
			timeout = -1;
		}

		IMessageEvent me = (IMessageEvent)getInitialEvent();
		Object task;
		IMessageEvent reply;
		List records = SCollection.createArrayList();
		Object[] proposal = null;

		for(int i=0; me.getType().equals("cnp_cfp"); i++)
		{
			getLogger().info("Negotiation round: "+i+" receiver got cfp: "+me);
			records.add(me);
			task = me.getContent();

			Exception ex = null;
			try
			{
				proposal = makeProposal(task); // todo: include information about negotiation round
			}
			catch(Exception e)
			{
				ex = e;
				e.printStackTrace();
			}
			if(ex!=null || proposal == null || proposal[0]==null)
			{
				reply = me.createReply("cnp_refuse");
				getLogger().info("No proposal made. Finished.");
				sendMessage(reply);
				return; // todo: ?
				//fail();
			}

			reply = me.createReply("cnp_propose");
			reply.setContent(proposal[0]);
			getLogger().info("Receiver sent proposal: "+reply);
			me = sendMessageAndWait(reply, timeout);
		}

		if(me.getType().equals("cnp_accept"))
		{
			getLogger().info("Doing the work.");
			try
			{
				Object result = executeTask(proposal[0], proposal[1]);
				reply = me.createReply("cnp_inform_done");
				reply.setContent(result); // todo: how to put in the Done()???
				getLogger().info("Receiver sent done: "+reply);
				sendMessage(reply);
			}
			catch(Exception e)
			{
				reply = me.createReply("cnp_failure");
				getLogger().info("Receiver sent failure: "+reply);
				sendMessage(reply);
			}
		}
		else
		{
			getLogger().info("Proposal rejected. Finished.");
		}
	}

	/**
	 *  Make a proposal based on the task description.
	 *  @param task The task to execute.
	 *  @return The proposal for executing the task.
	 */
	public Object[] makeProposal(Object task)
	{
		IGoal make_proposal = createGoal("cnp_make_proposal");
		make_proposal.getParameter("task").setValue(task);
		dispatchSubgoalAndWait(make_proposal);
		return new Object[]{make_proposal.getParameter("proposal").getValue(),
			make_proposal.getParameter("proposal_info").getValue()};
	}

	/**
	 *  Execute the task.
	 *  @param proposal The proposal.
	 *  @param proposal_info The proposal info.
	 *  @return The result of the task.
	 */
	public Object executeTask(Object proposal, Object proposal_info)
	{
		IGoal execute_task = createGoal("cnp_execute_task");
		execute_task.getParameter("proposal").setValue(proposal);
		execute_task.getParameter("proposal_info").setValue(proposal_info);
		dispatchSubgoalAndWait(execute_task);
		return execute_task.getParameter("result").getValue();
	}
}

