package jadex.model;

/**
 *  Configuration settings for included capabilities.
 */
public interface IMConfigCapabilitybase extends IMConfigBase
{
	//-------- initial capabilities --------

	/**
	 *  Get all defined capabilities.
	 *  @return The capabilities.
	 */
	public IMConfigCapability[] getInitialCapabilities();

	/**
	 *  Create a new initial capability.
	 *  @param ref	The name of the referenced capability.
	 *  @param state	The initial state.
	 *  @return	The newly created initial capability.
	 */
	public IMConfigCapability	createInitialCapability(String ref, String state);

	/**
	 *  Delete a capability.
	 *  @param capability	The capability to delete.
	 */
	public void	deleteInitialCapability(IMConfigCapability capability);
	
	//-------- not xml related --------
	
	/**
	 *  Get the initial configuration for a given capability.
	 *  @param subcap	The subcapability.
	 *  @return	The initial capability configuration.
	 */
	public IMConfigCapability	getInitialCapability(IMCapabilityReference subcap);


}
