/*
 * CreatureData.java
 *
 * Generated by Protege plugin Beanynizer. 
 * Changes will be lost! 
 */
package jadex.examples.hunterprey;

import jadex.adapter.fipa.AgentIdentifier;


/**
 *  Java class for concept Creature of hunterprey_beans ontology.
 */
public abstract class CreatureData	extends WorldObject implements nuggets.INugget, java.io.Serializable
{
	//-------- constants ----------

	//-------- attributes ----------

	/** The age of the creature (in simulation steps). */
	protected  int  age;

	/** Attribute for slot points. */
	protected  int  points;

	/** Unique name for this creature. */
	protected  String  name;

	/** Agent identifier of the creature. */
	protected transient AgentIdentifier  aid;

	/** The distance a creature is able to see. */
	protected  int  visionrange;

	/** The width of the world. */
	protected  int  worldwidth;

	/** The height of the world. */
	protected  int  worldheight;

	/** The number of simulation ticks, this creature is considered alive. */
	protected  int  leaseticks;

	//-------- constructors --------

	/**
	 *  Default Constructor. <br>
	 *  Create a new <code>Creature</code>.
	 */
	public CreatureData()  { //
	}

	//-------- accessor methods --------

	/**
	 *  Get the age of this Creature.
	 *  The age of the creature (in simulation steps).
	 * @return age
	 */
	public int  getAge() {
		return this.age;
	}

	/**
	 *  Set the age of this Creature.
	 *  The age of the creature (in simulation steps).
	 * @param age the value to be set
	 */
	public void  setAge(int age) {
		this.age = age;
	}

	/**
	 *  Get the points of this Creature.
	 * @return points
	 */
	public int  getPoints() {
		return this.points;
	}

	/**
	 *  Set the points of this Creature.
	 * @param points the value to be set
	 */
	public void  setPoints(int points) {
		this.points = points;
	}

	/**
	 *  Get the name of this Creature.
	 *  Unique name for this creature.
	 * @return name
	 */
	public String  getName() {
		return this.name;
	}

	/**
	 *  Set the name of this Creature.
	 *  Unique name for this creature.
	 * @param name the value to be set
	 */
	public void  setName(String name) {
		this.name = name;
	}

	/**
	 *  Get the aid of this Creature.
	 *  Agent identifier of the creature.
	 * @return aid
	 */
	public AgentIdentifier  getAID() {
		return this.aid;
	}

	/**
	 *  Set the aid of this Creature.
	 *  Agent identifier of the creature.
	 * @param aid the value to be set
	 */
	public void  setAID(AgentIdentifier aid) {
		this.aid = aid;
	}

	/**
	 *  Get the visionrange of this Creature.
	 *  The distance a creature is able to see.
	 * @return visionrange
	 */
	public int  getVisionRange() {
		return this.visionrange;
	}

	/**
	 *  Set the visionrange of this Creature.
	 *  The distance a creature is able to see.
	 * @param visionrange the value to be set
	 */
	public void  setVisionRange(int visionrange) {
		this.visionrange = visionrange;
	}

	/**
	 *  Get the world-width of this Creature.
	 *  The width of the world.
	 * @return world-width
	 */
	public int  getWorldWidth() {
		return this.worldwidth;
	}

	/**
	 *  Set the world-width of this Creature.
	 *  The width of the world.
	 * @param worldwidth the value to be set
	 */
	public void  setWorldWidth(int worldwidth) {
		this.worldwidth = worldwidth;
	}

	/**
	 *  Get the world-height of this Creature.
	 *  The height of the world.
	 * @return world-height
	 */
	public int  getWorldHeight() {
		return this.worldheight;
	}

	/**
	 *  Set the world-height of this Creature.
	 *  The height of the world.
	 * @param worldheight the value to be set
	 */
	public void  setWorldHeight(int worldheight) {
		this.worldheight = worldheight;
	}

	/**
	 *  Get the leaseticks of this Creature.
	 *  The number of simulation ticks, this creature is considered alive.
	 * @return leaseticks
	 */
	public int  getLeaseticks() {
		return this.leaseticks;
	}

	/**
	 *  Set the leaseticks of this Creature.
	 *  The number of simulation ticks, this creature is considered alive.
	 * @param leaseticks the value to be set
	 */
	public void  setLeaseticks(int leaseticks) {
		this.leaseticks = leaseticks;
	}

	//-------- object methods --------

	/**
	 *  Get a string representation of this Creature.
	 *  @return The string representation.
	 */
	public String toString() {
		return "Creature("
		+ "aid="+getAID()
		+ ", location="+getLocation()
		+ ", name="+getName()
           + ")";
	}
	
	//--------- nuggets methods ---------
	
	/**
	 * Persist this Creature using the nuggets utility.
	 * @param c 
	 */
	public void _persist(nuggets.ICruncher c) {
		// declare references
		int idAID = c.declare(aid);
		int idLocation = c.declare(location);
		// persist the nugget
		c.startConcept(this);
		if (age!=0) 
			c.put("Age", String.valueOf(age));
		if (idAID>0) 
			c.put("AID", idAID);
		if (leaseticks!=0) 
			c.put("Leaseticks", String.valueOf(leaseticks));
		if (idLocation>0) 
			c.put("Location", idLocation);
		if (name!=null) 
			c.put("Name", name);
		if (points!=0) 
			c.put("Points", String.valueOf(points));
		if (visionrange!=0) 
			c.put("VisionRange", String.valueOf(visionrange));
		if (worldheight!=0) 
			c.put("WorldHeight", String.valueOf(worldheight));
		if (worldwidth!=0) 
			c.put("WorldWidth", String.valueOf(worldwidth));
	}
	
	/**
	 * Restore this Creature 
	 * @param a the name of the attribute
	 * @param v the value of the attribute
	 */
	public void _set(String a, Object v) { //
		switch(hash(a)) {
		case 0: aid =  (AgentIdentifier)v; return;
		case 1: visionrange =  Integer.parseInt((String)v); return;
		case 2: leaseticks =  Integer.parseInt((String)v); return;
		case 3: age =  Integer.parseInt((String)v); return;
		case 4: points =  Integer.parseInt((String)v); return;
		case 5: name =  (String)v; return;
		case 6: location =  (Location)v; return;
		case 7: worldwidth =  Integer.parseInt((String)v); return;
		case 8: worldheight =  Integer.parseInt((String)v); return;
		}                        
	}
	
private static final int hash(String name) {
  int h=0;
  int c=name.length();
   h += 1970117235*name.charAt(2);
   if (c<=5) return (h>>>15)%9;
   h += 741244220*name.charAt(5);
   return (h>>>15)%9;
}

}
