package jadex.examples.cleanerworld.multi.environment;

import jadex.examples.cleanerworld.multi.*;
import jadex.runtime.*;
import jadex.adapter.fipa.*;

/**
 *  A cleaner requests to drop waste into a waste-bin.
 *  This can fail, when the wastebin is already full.
 */
public class  DropWastePlan extends Plan
{
	//-------- constructors --------

	/**
	 *  Create a new plan.
	 */
	public  DropWastePlan()
	{
		getLogger().info("Created: "+this);
	}

	//------ methods -------

	/**
	 *  The plan body.
	 */
	public void body()
	{
		RequestDropWaste op = (RequestDropWaste)getParameter("request").getValue();
		Waste waste = op.getWaste();
		String wastebinname = op.getWastebinname();

		Environment env = (Environment)getBeliefbase().getBelief("environment").getFact();
		Wastebin wb = env.getWastebin(wastebinname);
		boolean success = env.dropWasteInWastebin(waste, wb);

		if(!success)
			fail();

		Done done = new Done();
		done.setAction(op);
		getParameter("result").setValue(op);
	}

	/**
	 *  The plan body.
	 * /
	public void body()
	{
		IMessageEvent req = (IMessageEvent)getInitialEvent();
		RequestDropWaste op = (RequestDropWaste)req.getContent();
		Waste waste = op.getWaste();
		String wastebinname = op.getWastebinname();

		Environment env = (Environment)getBeliefbase().getBelief("environment").getFact();
		Wastebin wb = env.getWastebin(wastebinname);
		boolean success = env.dropWasteInWastebin(waste, wb);

		if(success)
		{
			Done done = new Done();
			done.setAction((AgentAction)req.getContent());
			sendMessage(req.createReply("inform_done", done));
		}
		else
		{
			//todo: introduce failure predicate
			//ContentElementList cel = new ContentElementList();
			//cel.add((Action)req.getContent());
			//cel.add(new );
			//sendMessage(req.createReply("failure", cel));
			IMessageEvent	reply	=	req.createReply("failure", "failed");
			reply.getParameter(SFipa.LANGUAGE).setValue(null);	// Hack!!!
			sendMessage(reply);
		}
	}*/
}
