/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.transport.tcpmtp;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.standalone.IMessageEnvelope;
import jadex.adapter.standalone.IPlatform;
import jadex.adapter.standalone.ITransport;
import jadex.adapter.standalone.transport.codecs.CodecFactory;
import jadex.adapter.standalone.transport.tcpmtp.TCPDeadConnection;
import jadex.adapter.standalone.transport.tcpmtp.TCPInputConnection;
import jadex.adapter.standalone.transport.tcpmtp.TCPOutputConnection;
import jadex.util.SUtil;
import jadex.util.collection.ILRUEntryCleaner;
import jadex.util.collection.LRU;
import jadex.util.collection.MultiCollection;
import jadex.util.collection.SCollection;
import jadex.util.concurrent.ITimedObject;
import jadex.util.concurrent.ThreadPoolFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TCPTransport
implements ITransport {
    public static final String SCHEMA = "tcp-mtp://";
    public static final String ASYNCHRONOUS = "asynchronous";
    public static final String PORT = "port";
    protected static final int MAX_KEEPALIVE = 300000;
    protected static final int PROLOG_SIZE = 5;
    protected static final int BUFFER_SIZE = 0x200000;
    protected static final int MAX_CONNECTIONS = 10;
    protected static final int DEFAULT_PORT = 9876;
    protected IPlatform platform;
    protected String[] addresses;
    protected int port;
    protected ServerSocket serversocket;
    protected Map connections;
    protected boolean async;
    protected CodecFactory codecfac;
    protected Logger logger;

    public void init(IPlatform platform, Map settings) {
        try {
            this.logger = Logger.getLogger("TCPTransport" + this);
            this.codecfac = new CodecFactory();
            this.platform = platform;
            if (settings != null && settings.containsKey(PORT)) {
                this.port = (Integer)settings.get(PORT);
            }
            this.async = true;
            if (settings != null && settings.containsKey(ASYNCHRONOUS)) {
                this.async = (Boolean)settings.get(ASYNCHRONOUS);
            }
            this.connections = SCollection.createLRU(10);
            ((LRU)this.connections).setCleaner(new ILRUEntryCleaner(){

                public void cleanupEldestEntry(Map.Entry eldest) {
                    TCPOutputConnection con = (TCPOutputConnection)eldest.getValue();
                    con.close();
                }
            });
            this.connections = Collections.synchronizedMap(this.connections);
            this.serversocket = new ServerSocket(this.port);
            this.port = this.serversocket.getLocalPort();
            InetAddress iaddr = InetAddress.getLocalHost();
            String lhostname = iaddr.getHostName().toLowerCase();
            InetAddress[] laddrs = InetAddress.getAllByName(lhostname);
            HashSet<String> addrs = new HashSet<String>();
            addrs.add(this.getAddress(iaddr.getHostAddress(), this.port));
            for (int i = 0; i < laddrs.length; ++i) {
                String hostname = laddrs[i].getHostName().toLowerCase();
                String ip_addr = laddrs[i].getHostAddress();
                addrs.add(this.getAddress(ip_addr, this.port));
                if (ip_addr.equals(hostname)) continue;
                addrs.add(this.getAddress(hostname, this.port));
            }
            this.addresses = addrs.toArray(new String[addrs.size()]);
            ThreadPoolFactory.getThreadPool().execute(new Runnable(){

                public void run() {
                    while (!TCPTransport.this.serversocket.isClosed()) {
                        try {
                            TCPInputConnection con = new TCPInputConnection(TCPTransport.this.serversocket.accept(), TCPTransport.this.codecfac);
                            if (!TCPTransport.this.async) {
                                TCPTransport.this.deliverMessages(con);
                                continue;
                            }
                            ThreadPoolFactory.getThreadPool().execute(new Runnable(this, con){
                                private final /* synthetic */ TCPInputConnection val$con;
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$con = val$con;
                                }

                                public void run() {
                                    2.access$000(this.this$1).deliverMessages(this.val$con);
                                }
                            });
                        }
                        catch (IOException iOException) {}
                    }
                    TCPTransport.this.logger.warning("TCPTransport serversocket closed.");
                }

                static /* synthetic */ TCPTransport access$000(2 x0) {
                    return x0.TCPTransport.this;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Transport initialization error: " + e.getMessage());
        }
    }

    public void shutdown() {
        try {
            this.serversocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connections = null;
    }

    public AgentIdentifier[] sendMessage(IMessageEnvelope message) {
        AgentIdentifier[] recstodel = message.getReceivers();
        List undelivered = SUtil.arrayToList(recstodel);
        MultiCollection adrsets = new MultiCollection(SCollection.createHashMap(), HashSet.class);
        for (int i = 0; i < recstodel.length; ++i) {
            String[] addrs = recstodel[i].getAddresses();
            for (int j = 0; j < addrs.length; ++j) {
                adrsets.put(addrs[i], recstodel[i]);
            }
        }
        String[] addrs = (String[])adrsets.getKeys(String.class);
        for (int i = 0; i < addrs.length; ++i) {
            TCPOutputConnection con = this.getConnection(addrs[i]);
            if (con == null) continue;
            Set aidset = (Set)adrsets.get(addrs[i]);
            aidset.retainAll(undelivered);
            AgentIdentifier[] aids = aidset.toArray(new AgentIdentifier[aidset.size()]);
            message.setReceivers(aids);
            if (con.send(message)) {
                // empty if block
            }
            undelivered.removeAll(aidset);
        }
        return undelivered.toArray(new AgentIdentifier[undelivered.size()]);
    }

    public String getServiceSchema() {
        return SCHEMA;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    protected String getAddress(String hostname, int port) {
        return this.getServiceSchema() + hostname + ":" + port;
    }

    protected TCPOutputConnection getConnection(String address) {
        TCPDeadConnection dead;
        Object ret = this.connections.get(address = address.toLowerCase());
        if (ret instanceof TCPOutputConnection && ((TCPOutputConnection)ret).isClosed()) {
            this.removeConnection(address);
            ret = null;
        }
        if (ret instanceof TCPDeadConnection && (dead = (TCPDeadConnection)ret).shouldRetry()) {
            this.connections.remove(address);
            ret = null;
        }
        if (ret == null) {
            ret = this.createConnection(address);
        }
        if (ret instanceof TCPDeadConnection) {
            ret = null;
        }
        return (TCPOutputConnection)ret;
    }

    protected TCPOutputConnection createConnection(String address) {
        TCPOutputConnection ret = null;
        if ((address = address.toLowerCase()).startsWith(this.getServiceSchema())) {
            int iport;
            String hostname;
            int schemalen = this.getServiceSchema().length();
            int div = address.indexOf(58, schemalen);
            if (div > 0) {
                hostname = address.substring(schemalen, div);
                iport = Integer.parseInt(address.substring(div + 1));
            } else {
                hostname = address.substring(schemalen);
                iport = 9876;
            }
            try {
                ret = new TCPOutputConnection(InetAddress.getByName(hostname), iport, this.codecfac, new Cleaner(address));
                this.connections.put(address, ret);
            }
            catch (Exception e) {
                this.connections.put(address, new TCPDeadConnection());
                this.logger.warning("Could not create connection: " + e.getMessage());
            }
        }
        return ret;
    }

    protected void removeConnection(String address) {
        Object con = this.connections.remove(address = address.toLowerCase());
        if (con instanceof TCPOutputConnection) {
            ((TCPOutputConnection)con).close();
        }
    }

    protected void deliverMessages(TCPInputConnection con) {
        try {
            IMessageEnvelope msg = con.read();
            while (msg != null) {
                this.platform.getMessageService().deliverMessage(msg);
                msg = con.read();
            }
        }
        catch (Exception e) {
            this.logger.warning("TCPTransport receiving error: " + e);
            con.close();
        }
    }

    protected class Cleaner
    implements ITimedObject {
        protected String address;

        public Cleaner(String address) {
            this.address = address;
        }

        public void timeEventOccurred() {
            TCPTransport.this.removeConnection(this.address);
        }

        public void refresh() {
            TCPTransport.this.platform.getTimerService().addEntry(this, System.currentTimeMillis() + 300000L);
        }

        public void remove() {
            TCPTransport.this.platform.getTimerService().removeEntry(this);
        }
    }
}

