/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.transport.tcpmtp;

import jadex.adapter.standalone.IMessageEnvelope;
import jadex.adapter.standalone.transport.codecs.CodecFactory;
import jadex.adapter.standalone.transport.codecs.IEncoder;
import jadex.adapter.standalone.transport.tcpmtp.TCPTransport;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

class TCPOutputConnection {
    protected Socket sock;
    protected OutputStream sos;
    protected CodecFactory codecfac;
    protected TCPTransport.Cleaner cleaner;

    public TCPOutputConnection(InetAddress iaddr, int iport, CodecFactory codecfac, TCPTransport.Cleaner cleaner) throws IOException {
        this.sock = new Socket(iaddr, iport);
        this.sos = new BufferedOutputStream(this.sock.getOutputStream());
        this.codecfac = codecfac;
        this.cleaner = cleaner;
    }

    public synchronized boolean send(IMessageEnvelope msg) {
        boolean ret = false;
        try {
            IEncoder enc = this.codecfac.getDefaultEncoder();
            byte codec_id = this.codecfac.getCodecId(enc.getClass());
            if (codec_id == -1) {
                throw new IOException("Codec id not found: " + enc);
            }
            byte[] enc_msg = enc.encode(msg);
            int size = enc_msg.length + 5;
            this.sos.write(codec_id);
            this.sos.write(size >> 24 & 0xFF);
            this.sos.write(size >> 16 & 0xFF);
            this.sos.write(size >> 8 & 0xFF);
            this.sos.write(size & 0xFF);
            this.sos.write(enc_msg);
            this.sos.flush();
            ret = true;
            this.cleaner.refresh();
        }
        catch (IOException e) {
            this.close();
        }
        return ret;
    }

    public boolean isClosed() {
        return this.sock.isClosed();
    }

    public void close() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cleaner.remove();
    }
}

