/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.transport.tcpmtp;

import jadex.adapter.standalone.IMessageEnvelope;
import jadex.adapter.standalone.transport.codecs.CodecFactory;
import jadex.adapter.standalone.transport.codecs.IDecoder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class TCPInputConnection {
    static final int BUFFER_SIZE = 0x200000;
    protected Socket sock;
    protected InputStream is;
    protected byte[] buffer;
    protected CodecFactory codecfac;

    public TCPInputConnection(Socket sock, CodecFactory codecfac) throws IOException {
        this.sock = sock;
        this.codecfac = codecfac;
        this.buffer = new byte[0x200000];
        this.is = new BufferedInputStream(sock.getInputStream());
    }

    public IMessageEnvelope read() throws IOException {
        IMessageEnvelope ret = null;
        byte codec_id = (byte)this.readByte();
        int msg_size = this.readByte() << 24 | this.readByte() << 16 | this.readByte() << 8 | this.readByte();
        if ((msg_size -= 5) <= this.buffer.length && msg_size > 0) {
            int count;
            int bytes_read;
            for (count = 0; count < msg_size; count += bytes_read) {
                bytes_read = this.is.read(this.buffer, count, msg_size - count);
                if (bytes_read != -1) continue;
                throw new IOException("Stream closed");
            }
            byte[] rawmsg = new byte[count];
            System.arraycopy(this.buffer, 0, rawmsg, 0, count);
            IDecoder dec = this.codecfac.getDecoder(codec_id);
            ret = (IMessageEnvelope)dec.decode(rawmsg);
        }
        return ret;
    }

    public void close() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int readByte() throws IOException {
        int ret = this.is.read();
        if (ret == -1) {
            throw new IOException("No data available.");
        }
        return ret;
    }
}

