/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.transport.niotcpmtp;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.standalone.IMessageEnvelope;
import jadex.adapter.standalone.IPlatform;
import jadex.adapter.standalone.ITransport;
import jadex.adapter.standalone.transport.codecs.CodecFactory;
import jadex.adapter.standalone.transport.niotcpmtp.NIOTCPDeadConnection;
import jadex.adapter.standalone.transport.niotcpmtp.NIOTCPInputConnection;
import jadex.adapter.standalone.transport.niotcpmtp.NIOTCPOutputConnection;
import jadex.util.SUtil;
import jadex.util.collection.ILRUEntryCleaner;
import jadex.util.collection.LRU;
import jadex.util.collection.MultiCollection;
import jadex.util.collection.SCollection;
import jadex.util.concurrent.ITimedObject;
import jadex.util.concurrent.ThreadPoolFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class NIOTCPTransport
implements ITransport {
    public static final String SCHEMA = "nio-mtp://";
    protected static final int MAX_KEEPALIVE = 300000;
    protected static final int PROLOG_SIZE = 5;
    protected static final int BUFFER_SIZE = 0x200000;
    protected static final int MAX_CONNECTIONS = 10;
    protected static final int DEFAULT_PORT = 8765;
    protected IPlatform platform;
    protected String[] addresses;
    protected int port;
    protected ServerSocketChannel ssc;
    protected Selector selector;
    protected Map connections;
    protected CodecFactory codecfac;
    protected Logger logger;

    public void init(final IPlatform platform, Map settings) {
        try {
            this.logger = Logger.getLogger("NIOTCPTransport" + this);
            this.codecfac = new CodecFactory();
            this.platform = platform;
            if (settings != null && settings.containsKey("port")) {
                this.port = (Integer)settings.get("port");
            }
            this.connections = SCollection.createLRU(10);
            ((LRU)this.connections).setCleaner(new ILRUEntryCleaner(){

                public void cleanupEldestEntry(Map.Entry eldest) {
                    NIOTCPOutputConnection con = (NIOTCPOutputConnection)eldest.getValue();
                    con.close();
                }
            });
            this.ssc = ServerSocketChannel.open();
            this.ssc.configureBlocking(false);
            ServerSocket serversocket = this.ssc.socket();
            serversocket.bind(new InetSocketAddress(this.port));
            this.port = serversocket.getLocalPort();
            this.selector = Selector.open();
            this.ssc.register(this.selector, 16);
            InetAddress iaddr = InetAddress.getLocalHost();
            String lhostname = iaddr.getHostName().toLowerCase();
            InetAddress[] laddrs = InetAddress.getAllByName(lhostname);
            HashSet<String> addrs = new HashSet<String>();
            addrs.add(this.getAddress(iaddr.getHostAddress(), this.port));
            for (int i = 0; i < laddrs.length; ++i) {
                String hostname = laddrs[i].getHostName().toLowerCase();
                String ip_addr = laddrs[i].getHostAddress();
                addrs.add(this.getAddress(ip_addr, this.port));
                if (ip_addr.equals(hostname)) continue;
                addrs.add(this.getAddress(hostname, this.port));
            }
            this.addresses = addrs.toArray(new String[addrs.size()]);
            ThreadPoolFactory.getThreadPool().execute(new Runnable(){

                public void run() {
                    while (NIOTCPTransport.this.ssc.isOpen()) {
                        Iterator<SelectionKey> it = null;
                        try {
                            NIOTCPTransport.this.selector.select();
                            it = NIOTCPTransport.this.selector.selectedKeys().iterator();
                        }
                        catch (IOException e) {
                            NIOTCPTransport.this.logger.warning("NIOTCP selector error.");
                        }
                        while (it != null && it.hasNext()) {
                            SelectionKey key = it.next();
                            it.remove();
                            if (key.isValid() && key.isAcceptable()) {
                                try {
                                    SocketChannel sc = NIOTCPTransport.this.ssc.accept();
                                    if (sc == null) continue;
                                    sc.configureBlocking(false);
                                    sc.register(NIOTCPTransport.this.selector, 1, new NIOTCPInputConnection(sc, NIOTCPTransport.this.codecfac));
                                }
                                catch (IOException e) {
                                    NIOTCPTransport.this.logger.warning("NIOTCP connection error on receiver side.");
                                    key.cancel();
                                }
                                continue;
                            }
                            if (key.isValid() && key.isReadable()) {
                                NIOTCPInputConnection con = (NIOTCPInputConnection)key.attachment();
                                try {
                                    IMessageEnvelope msg = con.read();
                                    while (msg != null) {
                                        platform.getMessageService().deliverMessage(msg);
                                        msg = con.read();
                                    }
                                    continue;
                                }
                                catch (IOException e) {
                                    NIOTCPTransport.this.logger.warning("NIOTCP receiving error while reading data.");
                                    con.close();
                                    key.cancel();
                                    continue;
                                }
                            }
                            key.cancel();
                        }
                    }
                    NIOTCPTransport.this.logger.info("TCPNIO receiver closed.");
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Transport initialization error: " + e.getMessage());
        }
    }

    public void shutdown() {
        try {
            this.ssc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connections = null;
    }

    public AgentIdentifier[] sendMessage(IMessageEnvelope message) {
        AgentIdentifier[] recstodel = message.getReceivers();
        List undelivered = SUtil.arrayToList(recstodel);
        MultiCollection adrsets = new MultiCollection(SCollection.createHashMap(), HashSet.class);
        for (int i = 0; i < recstodel.length; ++i) {
            String[] addrs = recstodel[i].getAddresses();
            for (int j = 0; j < addrs.length; ++j) {
                adrsets.put(addrs[i], recstodel[i]);
            }
        }
        String[] addrs = (String[])adrsets.getKeys(String.class);
        block6: for (int i = 0; i < addrs.length; ++i) {
            try {
                boolean fresh = false;
                NIOTCPOutputConnection con = this.getConnection(addrs[i]);
                if (con == null) {
                    fresh = true;
                    con = this.createConnection(addrs[i]);
                }
                if (con == null) continue;
                Set aidset = (Set)adrsets.get(addrs[i]);
                aidset.retainAll(undelivered);
                AgentIdentifier[] aids = aidset.toArray(new AgentIdentifier[aidset.size()]);
                message.setReceivers(aids);
                while (true) {
                    try {
                        con.send(message);
                        undelivered.removeAll(aidset);
                    }
                    catch (IOException e) {
                        this.removeConnection(addrs[i]);
                        if (!fresh) {
                            fresh = true;
                            if ((con = this.createConnection(addrs[i])) != null) continue;
                            continue block6;
                        }
                        this.logger.warning("Send connection closed: " + addrs[i]);
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.logger.warning("Address unreachable: " + addrs[i]);
            }
        }
        return undelivered.toArray(new AgentIdentifier[undelivered.size()]);
    }

    public String getServiceSchema() {
        return SCHEMA;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    protected String getAddress(String hostname, int port) {
        return this.getServiceSchema() + hostname + ":" + port;
    }

    protected NIOTCPOutputConnection getConnection(String address) throws IOException {
        Object ret = this.connections.get(address = address.toLowerCase());
        if (ret instanceof NIOTCPDeadConnection) {
            NIOTCPDeadConnection dead = (NIOTCPDeadConnection)ret;
            if (dead.shouldRetry()) {
                this.connections.remove(address);
                ret = null;
            } else {
                throw new IOException("Dead connection.");
            }
        }
        return (NIOTCPOutputConnection)ret;
    }

    protected void removeConnection(String address) {
        NIOTCPOutputConnection con = (NIOTCPOutputConnection)this.connections.remove(address = address.toLowerCase());
        if (con != null) {
            con.close();
        }
    }

    protected NIOTCPOutputConnection createConnection(String address) {
        address = address.toLowerCase();
        NIOTCPOutputConnection ret = null;
        if (address.startsWith(this.getServiceSchema())) {
            int iport;
            String hostname;
            int schemalen = this.getServiceSchema().length();
            int div = address.indexOf(58, schemalen);
            if (div > 0) {
                hostname = address.substring(schemalen, div);
                iport = Integer.parseInt(address.substring(div + 1));
            } else {
                hostname = address.substring(schemalen);
                iport = 8765;
            }
            try {
                ret = new NIOTCPOutputConnection(InetAddress.getByName(hostname), iport, this.codecfac, new Cleaner(address));
                this.connections.put(address, ret);
            }
            catch (Exception e) {
                this.connections.put(address, new NIOTCPDeadConnection());
                this.logger.warning("Could not establish connection to: " + hostname + ":" + iport);
            }
        }
        return ret;
    }

    protected class Cleaner
    implements ITimedObject {
        protected String address;

        public Cleaner(String address) {
            this.address = address;
        }

        public void timeEventOccurred() {
            NIOTCPTransport.this.removeConnection(this.address);
        }

        public void refresh() {
            NIOTCPTransport.this.platform.getTimerService().addEntry(this, System.currentTimeMillis() + 300000L);
        }

        public void remove() {
            NIOTCPTransport.this.platform.getTimerService().removeEntry(this);
        }
    }
}

