/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.transport.niotcpmtp;

import jadex.adapter.standalone.IMessageEnvelope;
import jadex.adapter.standalone.transport.codecs.CodecFactory;
import jadex.adapter.standalone.transport.codecs.IEncoder;
import jadex.adapter.standalone.transport.niotcpmtp.NIOTCPTransport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

class NIOTCPOutputConnection {
    public static final int BUFFER_SIZE = 0x200000;
    protected SocketChannel sc;
    protected ByteBuffer buffer;
    protected long deadtime;
    protected CodecFactory codecfac;
    protected NIOTCPTransport.Cleaner cleaner;

    public NIOTCPOutputConnection(InetAddress iaddr, int iport, CodecFactory codecfac, NIOTCPTransport.Cleaner cleaner) throws IOException {
        this.codecfac = codecfac;
        this.cleaner = cleaner;
        this.sc = SocketChannel.open();
        this.sc.connect(new InetSocketAddress(iaddr, iport));
        this.buffer = ByteBuffer.allocateDirect(0x200000);
    }

    public synchronized void send(IMessageEnvelope msg) throws IOException {
        IEncoder enc = this.codecfac.getDefaultEncoder();
        byte codec_id = this.codecfac.getCodecId(enc.getClass());
        byte[] enc_msg = enc.encode(msg);
        int size = enc_msg.length + 5;
        this.buffer.put(codec_id);
        this.buffer.putInt(size);
        this.buffer.put(enc_msg);
        this.buffer.flip();
        this.sc.write(this.buffer);
        this.buffer.clear();
        this.cleaner.refresh();
    }

    public void close() {
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cleaner.remove();
    }
}

