/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.transport.niotcpmtp;

import jadex.adapter.standalone.IMessageEnvelope;
import jadex.adapter.standalone.transport.codecs.CodecFactory;
import jadex.adapter.standalone.transport.codecs.IDecoder;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class NIOTCPInputConnection {
    static final int BUFFER_SIZE = 0x200000;
    protected SocketChannel sc;
    protected ByteBuffer writebuffer;
    protected ByteBuffer readbuffer;
    protected int msg_end;
    protected byte codec_id;
    protected CodecFactory codecfac;

    public NIOTCPInputConnection(SocketChannel sc, CodecFactory codecfac) {
        this.sc = sc;
        this.codecfac = codecfac;
        this.writebuffer = ByteBuffer.allocateDirect(0x200000);
        this.readbuffer = this.writebuffer.asReadOnlyBuffer();
        this.msg_end = -1;
        this.codec_id = (byte)-1;
    }

    public IMessageEnvelope read() throws IOException {
        IMessageEnvelope ret = null;
        if (this.sc.read(this.writebuffer) == -1) {
            throw new IOException("Channel closed.");
        }
        if (this.msg_end == -1 && this.writebuffer.position() >= 5) {
            this.codec_id = this.readbuffer.get();
            this.msg_end = this.readbuffer.getInt();
            if (this.msg_end > this.writebuffer.limit()) {
                throw new BufferOverflowException();
            }
            if (this.msg_end <= 0) {
                throw new BufferUnderflowException();
            }
        }
        if (this.msg_end != -1 && this.msg_end <= this.writebuffer.position()) {
            this.readbuffer.limit(this.msg_end);
            byte[] rawbytes = new byte[this.msg_end - 5];
            this.readbuffer.get(rawbytes);
            IDecoder dec = this.codecfac.getDecoder(this.codec_id);
            ret = (IMessageEnvelope)dec.decode(rawbytes);
            this.writebuffer.limit(this.writebuffer.position());
            this.writebuffer.position(this.msg_end);
            this.writebuffer.compact();
            this.readbuffer.clear();
            this.msg_end = -1;
            this.codec_id = (byte)-1;
        }
        return ret;
    }

    public void close() {
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

