/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.transport.localmtp;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.standalone.IMessageEnvelope;
import jadex.adapter.standalone.IMessageService;
import jadex.adapter.standalone.IPlatform;
import jadex.adapter.standalone.ITransport;
import jadex.config.Configuration;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Map;

public class LocalTransport
implements ITransport {
    public static final String SCHEMA = "local-mtp://";
    protected IMessageService msgservice;
    protected String[] addresses;

    public void init(IPlatform platform, Map settings) {
        this.msgservice = platform.getMessageService();
        this.addresses = new String[0];
    }

    public void shutdown() {
    }

    public AgentIdentifier[] sendMessage(IMessageEnvelope message) {
        ArrayList todeliver = SCollection.createArrayList();
        ArrayList undelivered = SCollection.createArrayList();
        AgentIdentifier[] recs = message.getReceivers();
        String hap = Configuration.getConfiguration().getProperty("platformname");
        for (int i = 0; i < recs.length; ++i) {
            if (recs[i] == null) {
                System.out.println("here");
            }
            if (recs[i].getPlatformName().equals(hap)) {
                todeliver.add(recs[i]);
                continue;
            }
            undelivered.add(recs[i]);
        }
        if (todeliver.size() > 0) {
            message.setReceivers(todeliver.toArray(new AgentIdentifier[todeliver.size()]));
            this.msgservice.deliverMessage(message);
        }
        return undelivered.toArray(new AgentIdentifier[undelivered.size()]);
    }

    public String getServiceSchema() {
        return "local:";
    }

    public String[] getAddresses() {
        return this.addresses;
    }
}

