/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.transport.codecs;

import jadex.adapter.standalone.transport.codecs.IDecoder;
import jadex.adapter.standalone.transport.codecs.IEncoder;
import jadex.adapter.standalone.transport.codecs.NuggetsCodec;
import jadex.adapter.standalone.transport.codecs.SerialCodec;
import jadex.adapter.standalone.transport.codecs.XMLCodec;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.lang.reflect.Field;
import java.util.Map;

public class CodecFactory {
    protected Map codecclasses = SCollection.createHashMap();
    protected Map codeccache = SCollection.createHashMap();
    protected byte default_id = 1;

    public CodecFactory() {
        this.addCodec(SerialCodec.class);
        this.addCodec(NuggetsCodec.class);
        this.addCodec(XMLCodec.class);
    }

    public IEncoder getDefaultEncoder() {
        return this.getEncoder(this.default_id);
    }

    public IDecoder getDefaultDecoder() {
        return this.getDecoder(this.default_id);
    }

    public IEncoder getEncoder(byte id) {
        Byte idd = new Byte(id);
        IEncoder ret = (IEncoder)this.codeccache.get(idd);
        if (!this.codecclasses.containsKey(idd)) {
            throw new IllegalArgumentException("Unknown codec id: " + id);
        }
        if (ret == null) {
            Class cc = (Class)this.codecclasses.get(idd);
            try {
                ret = (IEncoder)cc.newInstance();
                this.codeccache.put(idd, ret);
            }
            catch (Exception e) {
                throw new RuntimeException("Decoder not found: " + id);
            }
        }
        return ret;
    }

    public IDecoder getDecoder(byte id) {
        Byte idd = new Byte(id);
        IDecoder ret = (IDecoder)this.codeccache.get(idd);
        if (!this.codecclasses.containsKey(idd)) {
            throw new IllegalArgumentException("Unknown codec id: " + id);
        }
        if (ret == null) {
            Class cc = (Class)this.codecclasses.get(idd);
            try {
                ret = (IDecoder)cc.newInstance();
                this.codeccache.put(idd, ret);
            }
            catch (Exception e) {
                throw new RuntimeException("Decoder not found: " + id);
            }
        }
        return ret;
    }

    public void setDefaultCodec(Object codec) {
        this.default_id = this.getCodecId(codec.getClass());
    }

    public byte getDefaultCodecId() {
        return this.default_id;
    }

    public void addCodec(String codec_clname) throws ClassNotFoundException {
        this.addCodec(SReflect.classForName(codec_clname));
    }

    public void removeCodec(String codec_clname) throws ClassNotFoundException {
        this.removeCodec(SReflect.classForName(codec_clname));
    }

    public void addCodec(Class codec_class) {
        try {
            Field f = codec_class.getDeclaredField("CODEC_ID");
            Byte codec_id = new Byte(f.getByte(null));
            this.codecclasses.put(codec_id, codec_class);
        }
        catch (Exception e) {
            throw new RuntimeException("Codec id not found. Needs explicit CODEC_ID spec: " + codec_class);
        }
    }

    public void removeCodec(Class codec_class) {
        try {
            Field f = codec_class.getDeclaredField("CODEC_ID");
            Byte codec_id = new Byte(f.getByte(null));
            this.codecclasses.remove(codec_id);
            this.codeccache.remove(codec_id);
        }
        catch (Exception e) {
            throw new RuntimeException("Codec id not found. Needs explicit CODEC_ID spec: " + codec_class);
        }
    }

    public byte getCodecId(Class codec_class) {
        byte ret = -1;
        try {
            Field f = codec_class.getDeclaredField("CODEC_ID");
            ret = f.getByte(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Codec id not found. Needs explicit CODEC_ID spec: " + codec_class);
        }
        return ret;
    }
}

