/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.df;

import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.SearchConstraints;
import jadex.adapter.fipa.ServiceDescription;
import jadex.adapter.standalone.IDF;
import jadex.util.collection.IndexMap;
import java.util.ArrayList;
import java.util.HashSet;

public class DF
implements IDF {
    protected IndexMap agents = new IndexMap();

    public void register(AgentDescription adesc) {
        AgentDescription clone = (AgentDescription)adesc.clone();
        if (clone.getLeaseTime() == null || clone.getLeaseTime().getTime() > System.currentTimeMillis()) {
            if (this.agents.containsKey(clone.getName())) {
                throw new RuntimeException("Agent already registered: " + adesc.getName());
            }
            this.agents.add(clone.getName(), (Object)clone);
        }
    }

    public void deregister(AgentDescription adesc) {
        if (!this.agents.containsKey(adesc.getName())) {
            throw new RuntimeException("Agent not registered: " + adesc.getName());
        }
        this.agents.removeKey(adesc.getName());
    }

    public void modify(AgentDescription adesc) {
        AgentDescription clone = (AgentDescription)adesc.clone();
        if (clone.getLeaseTime() != null && clone.getLeaseTime().getTime() <= System.currentTimeMillis()) {
            throw new RuntimeException("Invalid lease time: " + clone.getLeaseTime());
        }
        this.agents.replace(clone.getName(), clone);
    }

    public AgentDescription[] search(AgentDescription adesc, SearchConstraints con) {
        ArrayList<AgentDescription> ret = new ArrayList<AgentDescription>();
        if (adesc.getName() != null) {
            if (this.agents.containsKey(adesc.getName())) {
                AgentDescription ad = (AgentDescription)this.agents.get(adesc.getName());
                if (ad.getLeaseTime() != null && ad.getLeaseTime().getTime() < System.currentTimeMillis()) {
                    this.agents.removeKey(ad.getName());
                } else {
                    ret.add(ad);
                }
            }
        } else {
            AgentDescription[] descs = (AgentDescription[])this.agents.toArray(new AgentDescription[this.agents.size()]);
            for (int i = 0; (con == null || con.getMaxResults() == -1 || ret.size() < con.getMaxResults()) && i < descs.length; ++i) {
                if (descs[i].getLeaseTime() != null && descs[i].getLeaseTime().getTime() < System.currentTimeMillis()) {
                    this.agents.removeKey(descs[i].getName());
                    continue;
                }
                if (!this.match(descs[i], adesc)) continue;
                ret.add(descs[i]);
            }
        }
        return ret.toArray(new AgentDescription[ret.size()]);
    }

    public void shutdown() {
    }

    protected boolean match(AgentDescription desc, AgentDescription template) {
        boolean ret = true;
        ret = this.includes(desc.getLanguages(), template.getLanguages());
        ret = ret && this.includes(desc.getOntologies(), template.getOntologies());
        boolean bl = ret = ret && this.includes(desc.getProtocols(), template.getProtocols());
        if (ret) {
            ServiceDescription[] tservices = template.getServices();
            for (int t = 0; ret && t < tservices.length; ++t) {
                ret = false;
                ServiceDescription[] dservices = desc.getServices();
                for (int d = 0; !ret && d < dservices.length; ++d) {
                    ret = this.match(dservices[d], tservices[t]);
                }
            }
        }
        return ret;
    }

    protected boolean match(ServiceDescription desc, ServiceDescription template) {
        boolean ret = template.getName() == null || template.getName().equals(desc.getName());
        ret = ret && (template.getType() == null || template.getType().equals(desc.getType()));
        ret = ret && (template.getOwnership() == null || template.getOwnership().equals(desc.getOwnership()));
        ret = ret && this.includes(desc.getLanguages(), template.getLanguages());
        ret = ret && this.includes(desc.getOntologies(), template.getOntologies());
        ret = ret && this.includes(desc.getProtocols(), template.getProtocols());
        ret = ret && this.includes(desc.getProperties(), template.getProperties());
        return ret;
    }

    protected boolean includes(Object[] a, Object[] b) {
        int i;
        HashSet<Object> entries = new HashSet<Object>();
        for (i = 0; i < b.length; ++i) {
            entries.add(b[i]);
        }
        for (i = 0; i < a.length; ++i) {
            entries.remove(a[i]);
        }
        return entries.isEmpty();
    }
}

