/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone.ams;

import jadex.adapter.IAgentAdapter;
import jadex.adapter.fipa.AMSAgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.SearchConstraints;
import jadex.adapter.standalone.IAMS;
import jadex.adapter.standalone.IPlatform;
import jadex.adapter.standalone.StandaloneAgentAdapter;
import jadex.model.SXML;
import jadex.util.SimplePropertyChangeSupport;
import jadex.util.collection.SCollection;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class AMS
implements IAMS {
    public static int agentcnt;
    protected IPlatform platform;
    protected Map adapters;
    protected Map agentdescs;
    protected SimplePropertyChangeSupport pcs;
    protected Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AMS(IPlatform platform) {
        this.platform = platform;
        this.adapters = Collections.synchronizedMap(SCollection.createHashMap());
        this.agentdescs = Collections.synchronizedMap(SCollection.createHashMap());
        this.pcs = new SimplePropertyChangeSupport(this);
        this.logger = Logger.getLogger(platform.getName() + ".ams");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentIdentifier createAgent(String name, String model, String config, Map args) {
        AgentIdentifier aid;
        if (name != null && name.indexOf(64) != -1) {
            throw new RuntimeException("No '@' allowed in agent name.");
        }
        if (this.platform.isShuttingDown()) {
            throw new RuntimeException("No new agents may be created when platform is shutting down.");
        }
        Map map = this.adapters;
        synchronized (map) {
            Map map2 = this.agentdescs;
            synchronized (map2) {
                if (name == null) {
                    aid = this.generateAgentIdentifier(SXML.getShortName(model));
                } else {
                    aid = new AgentIdentifier(name + "@" + this.platform.getName());
                    aid.setAddresses(this.platform.getMessageService().getAddresses());
                    if (this.adapters.containsKey(aid)) {
                        throw new RuntimeException("Agent name already exists on agent platform.");
                    }
                }
                StandaloneAgentAdapter agent = new StandaloneAgentAdapter(this.platform, aid, model, config, args);
                this.adapters.put(aid, agent);
                AMSAgentDescription ad = new AMSAgentDescription(aid);
                ad.setState(AMSAgentDescription.STATE_INITIATED);
                agent.setState(AMSAgentDescription.STATE_INITIATED);
                this.agentdescs.put(aid, ad);
            }
        }
        this.pcs.firePropertyChange("agents", null, this.adapters);
        return (AgentIdentifier)aid.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAgent(AgentIdentifier agent) {
        Map map = this.adapters;
        synchronized (map) {
            Map map2 = this.agentdescs;
            synchronized (map2) {
                StandaloneAgentAdapter adapter;
                AMSAgentDescription desc = (AMSAgentDescription)this.agentdescs.get(agent);
                if (desc != null && AMSAgentDescription.STATE_INITIATED.equals(desc.getState())) {
                    adapter = (StandaloneAgentAdapter)this.adapters.get(agent);
                    if (adapter == null) {
                        throw new RuntimeException("Cannot start unknown agent: " + agent);
                    }
                } else {
                    if (desc != null) {
                        throw new RuntimeException("Cannot start agent " + agent + " in state: " + desc.getState());
                    }
                    throw new RuntimeException("Cannot start unknown agent: " + agent);
                }
                desc.setState(AMSAgentDescription.STATE_ACTIVE);
                adapter.setState(AMSAgentDescription.STATE_ACTIVE);
                adapter.startAgent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAgent(AgentIdentifier aid) {
        Map map = this.adapters;
        synchronized (map) {
            Map map2 = this.agentdescs;
            synchronized (map2) {
                StandaloneAgentAdapter agent = (StandaloneAgentAdapter)this.adapters.get(aid);
                if (agent == null) {
                    System.out.println(this.agentdescs);
                    throw new RuntimeException("Agent " + aid + " does not exist.");
                }
                AMSAgentDescription desc = (AMSAgentDescription)this.agentdescs.get(aid);
                if (desc != null && !AMSAgentDescription.STATE_INITIATED.equals(desc.getState())) {
                    if (!$assertionsDisabled && AMSAgentDescription.STATE_TERMINATED.equals(desc.getState())) {
                        throw new AssertionError(agent);
                    }
                    if (!AMSAgentDescription.STATE_TERMINATING.equals(desc.getState())) {
                        agent.setState(AMSAgentDescription.STATE_TERMINATING);
                        desc.setState(AMSAgentDescription.STATE_TERMINATING);
                        agent.killAgent();
                    }
                } else {
                    agent.cleanupAgent();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgent(AgentIdentifier aid) {
        Map map = this.adapters;
        synchronized (map) {
            Map map2 = this.agentdescs;
            synchronized (map2) {
                StandaloneAgentAdapter adapter = (StandaloneAgentAdapter)this.adapters.remove(aid);
                if (adapter == null) {
                    throw new RuntimeException("Agent Identifier not registered in AMS: " + aid);
                }
                adapter.setState(AMSAgentDescription.STATE_TERMINATED);
                this.agentdescs.remove(aid);
                this.pcs.firePropertyChange("agents", null, this.adapters);
            }
        }
    }

    public void suspendAgent(AgentIdentifier aid) {
        StandaloneAgentAdapter adapter = (StandaloneAgentAdapter)this.adapters.get(aid);
        AMSAgentDescription ad = (AMSAgentDescription)this.agentdescs.get(aid);
        if (adapter == null || ad == null) {
            throw new RuntimeException("Agent Identifier not registered in AMS: " + aid);
        }
        if (!AMSAgentDescription.STATE_ACTIVE.equals(ad.getState())) {
            throw new RuntimeException("Only active agents can be suspended: " + aid + " " + ad.getState());
        }
        ad.setState(AMSAgentDescription.STATE_SUSPENDED);
        adapter.setState(AMSAgentDescription.STATE_SUSPENDED);
        this.platform.getExecutorService().suspend(adapter);
        this.pcs.firePropertyChange("agents", null, this.adapters);
    }

    public void resumeAgent(AgentIdentifier aid) {
        StandaloneAgentAdapter adapter = (StandaloneAgentAdapter)this.adapters.get(aid);
        AMSAgentDescription ad = (AMSAgentDescription)this.agentdescs.get(aid);
        if (adapter == null || ad == null) {
            throw new RuntimeException("Agent Identifier not registered in AMS: " + aid);
        }
        if (!AMSAgentDescription.STATE_SUSPENDED.equals(ad.getState())) {
            throw new RuntimeException("Only suspended agents can be resumed: " + aid + " " + ad.getState());
        }
        ad.setState(AMSAgentDescription.STATE_ACTIVE);
        adapter.setState(AMSAgentDescription.STATE_ACTIVE);
        this.platform.getExecutorService().resume(adapter);
        this.pcs.firePropertyChange("agents", null, this.adapters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMSAgentDescription[] searchAgents(AMSAgentDescription adesc, SearchConstraints con) {
        AMSAgentDescription[] ret;
        if (adesc != null && adesc.getName() != null) {
            AMSAgentDescription ad = (AMSAgentDescription)this.agentdescs.get(adesc.getName());
            if (ad != null && ad.getName().equals(adesc.getName())) {
                ad.setName(this.refreshAgentIdentifier(ad.getName()));
                AMSAgentDescription desc = (AMSAgentDescription)ad.clone();
                ret = new AMSAgentDescription[]{desc};
            } else {
                ret = new AMSAgentDescription[]{};
            }
        } else {
            ArrayList<Object> tmp = new ArrayList<Object>();
            Map map = this.agentdescs;
            synchronized (map) {
                Iterator it = this.agentdescs.values().iterator();
                while (it.hasNext()) {
                    AMSAgentDescription test = (AMSAgentDescription)it.next();
                    if (adesc != null && (adesc.getOwnership() != null && !adesc.getOwnership().equals(test.getOwnership()) || adesc.getState() != null && !adesc.getState().equals(test.getState()))) continue;
                    tmp.add(test.clone());
                }
            }
            ret = tmp.toArray(new AMSAgentDescription[tmp.size()]);
        }
        return ret;
    }

    public boolean containsAgent(AgentIdentifier aid) {
        return this.adapters.containsKey(aid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAgentAdapter[] getAgentAdapters() {
        Map map = this.adapters;
        synchronized (map) {
            return this.adapters.values().toArray(new IAgentAdapter[this.adapters.size()]);
        }
    }

    public IAgentAdapter getAgentAdapter(AgentIdentifier aid) {
        return (IAgentAdapter)this.adapters.get(aid);
    }

    public AMSAgentDescription getAgentDescription(AgentIdentifier aid) {
        AMSAgentDescription ret = (AMSAgentDescription)this.agentdescs.get(aid);
        if (ret != null) {
            ret.setName(this.refreshAgentIdentifier(aid));
            ret = (AMSAgentDescription)ret.clone();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentIdentifier[] getAgentIdentifiers() {
        Map map = this.adapters;
        synchronized (map) {
            AgentIdentifier[] ret = this.adapters.keySet().toArray(new AgentIdentifier[this.adapters.size()]);
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.refreshAgentIdentifier(ret[i]);
            }
            return ret;
        }
    }

    public int getAgentCount() {
        return this.adapters.size();
    }

    public AgentIdentifier refreshAgentIdentifier(AgentIdentifier aid) {
        AgentIdentifier ret = (AgentIdentifier)aid.clone();
        if (this.adapters.containsKey(aid)) {
            ret.setAddresses(this.platform.getMessageService().getAddresses());
        }
        return ret;
    }

    protected AgentIdentifier generateAgentIdentifier(String typename) {
        AgentIdentifier ret = null;
        while (this.adapters.containsKey(ret = new AgentIdentifier(typename + agentcnt++ + "@" + this.platform.getName()))) {
        }
        ret.setAddresses(this.platform.getMessageService().getAddresses());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map map = this.adapters;
        synchronized (map) {
            AgentIdentifier[] agents = this.adapters.keySet().toArray(new AgentIdentifier[this.adapters.keySet().size()]);
            for (int i = 0; i < agents.length; ++i) {
                this.logger.warning("Agent did not terminate: " + agents[i]);
                try {
                    this.removeAgent(agents[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    static {
        $assertionsDisabled = !AMS.class.desiredAssertionStatus();
        agentcnt = 0;
    }
}

