/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone;

import jadex.adapter.IMessageEventTransport;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.standalone.MessageEnvelope;
import jadex.adapter.standalone.StandaloneAgentAdapter;
import jadex.model.IMMessageEvent;
import jadex.model.MessageType;
import jadex.runtime.ContentException;
import jadex.runtime.IContentCodec;
import jadex.runtime.MessageFailureException;
import jadex.runtime.impl.IRMessageEvent;
import jadex.util.collection.SCollection;
import java.util.HashMap;
import java.util.Properties;

public class StandaloneMessageEventTransport
implements IMessageEventTransport {
    protected StandaloneAgentAdapter agent;

    public StandaloneMessageEventTransport(StandaloneAgentAdapter agent) {
        this.agent = agent;
    }

    public boolean sendMessage(IRMessageEvent msgevent) {
        int i;
        MessageType type = ((IMMessageEvent)msgevent.getModelElement()).getMessageType();
        MessageType.ParameterSpecification[] params = type.getParameters();
        MessageType.ParameterSpecification[] paramsets = type.getParameterSets();
        HashMap message = SCollection.createHashMap();
        for (i = 0; i < params.length; ++i) {
            if (params[i].isDerived()) continue;
            message.put(params[i].getName(), msgevent.getParameter(params[i].getName()).getValue());
        }
        for (i = 0; i < paramsets.length; ++i) {
            if (paramsets[i].isDerived()) continue;
            message.put(paramsets[i].getName(), msgevent.getParameterSet(paramsets[i].getName()).getValues());
        }
        if ("fipa".equals(type.getName())) {
            AgentIdentifier[] recs = (AgentIdentifier[])msgevent.getParameterSet("receivers").getValues();
            if (recs.length == 0) {
                throw new MessageFailureException((Object)msgevent, "No receivers specified");
            }
            for (int i2 = 0; i2 < recs.length; ++i2) {
                if (recs[i2] != null) continue;
                throw new MessageFailureException((Object)msgevent, "A receiver nulls");
            }
            message.put("x-message-id", msgevent.getId());
            if (msgevent.getContent() != null) {
                IContentCodec codec;
                Properties props = new Properties();
                String lang = (String)msgevent.getParameter("language").getValue();
                String onto = (String)msgevent.getParameter("ontology").getValue();
                if (lang != null) {
                    props.put("language", lang);
                }
                if (onto != null) {
                    props.put("ontology", onto);
                }
                if ((codec = msgevent.getScope().getContentCodec(props)) == null && !(msgevent.getContent() instanceof String)) {
                    throw new ContentException("No content codec found for: " + props);
                }
                if (codec != null) {
                    message.put("content", codec.encode(msgevent.getContent()));
                } else {
                    message.put("content", msgevent.getContent());
                }
            }
        }
        if (message.get("sender") == null) {
            message.put("sender", this.agent.getAgentIdentifier());
        }
        MessageEnvelope msgenv = new MessageEnvelope(message, (AgentIdentifier[])message.get("receivers"), type.getName());
        this.agent.getPlatform().getMessageService().sendMessage(msgenv);
        return true;
    }
}

