/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone;

import jadex.adapter.IAgentAdapter;
import jadex.adapter.IJadexAgent;
import jadex.adapter.IMessageEventTransport;
import jadex.adapter.IToolAdapter;
import jadex.adapter.JadexAgentFactory;
import jadex.adapter.fipa.AMSAgentDescription;
import jadex.adapter.fipa.AgentAction;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.FipaMessageAdapter;
import jadex.adapter.fipa.SFipa;
import jadex.adapter.standalone.IMessageEnvelope;
import jadex.adapter.standalone.IPlatform;
import jadex.adapter.standalone.MessageEnvelope;
import jadex.adapter.standalone.StandaloneMessageEventTransport;
import jadex.util.collection.SCollection;
import jadex.util.concurrent.IExecutable;
import jadex.util.concurrent.ITimedObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuggets.Nuggets;

public class StandaloneAgentAdapter
implements IAgentAdapter,
IExecutable,
ITimedObject,
Serializable {
    public static final String PROPERTY_TOOL_ADAPTERS = "tooladapter";
    public static final String ADAPTER_PROPERTIES = "jadex.adapter.standalone.standalone_adapter";
    protected transient IPlatform platform;
    protected AgentIdentifier aid;
    protected IJadexAgent agent;
    protected List tooladapters;
    protected final LinkedList toolmsgqueue;
    protected Set replywiths;
    protected transient IMessageEventTransport[] transports;
    protected String state;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandaloneAgentAdapter(IPlatform platform, AgentIdentifier aid, String model, String state, Map args) {
        this.platform = platform;
        this.aid = aid;
        this.toolmsgqueue = SCollection.createLinkedList();
        this.replywiths = SCollection.createHashSet();
        this.transports = new IMessageEventTransport[1];
        this.transports[0] = new StandaloneMessageEventTransport(this);
        this.agent = JadexAgentFactory.createJadexAgent(this, model, state, args);
        this.tooladapters = SCollection.createArrayList();
        String[] keys = this.agent.getPropertyNames(PROPERTY_TOOL_ADAPTERS);
        for (int i = 0; i < keys.length; ++i) {
            IToolAdapter adapter = (IToolAdapter)this.agent.getProperty(keys[i]);
            this.tooladapters.add(adapter);
        }
    }

    public void startAgent() {
        this.wakeup();
    }

    public void wakeup() {
        if (!$assertionsDisabled && AMSAgentDescription.STATE_INITIATED.equals(this.state)) {
            throw new AssertionError(this);
        }
        this.platform.getExecutorService().execute(this);
    }

    public void notifyIn(long millis) {
        if (!$assertionsDisabled && AMSAgentDescription.STATE_INITIATED.equals(this.state)) {
            throw new AssertionError(this);
        }
        if (millis > -1L) {
            this.platform.getTimerService().addEntry(this, System.currentTimeMillis() + millis);
        } else {
            this.platform.getTimerService().removeEntry(this);
        }
    }

    public void cleanupAgent() {
        this.platform.getAMS().removeAgent(this.aid);
        this.platform.getTimerService().removeEntry(this);
        this.platform.getExecutorService().cancel(this);
    }

    public String getPlatformType() {
        return "standalone";
    }

    public String getPlatformPropertiesName() {
        return ADAPTER_PROPERTIES;
    }

    public IMessageEventTransport[] getMessageEventTransports() {
        return this.transports;
    }

    public AgentIdentifier getAgentIdentifier() {
        return this.platform.getAMS().refreshAgentIdentifier(this.aid);
    }

    public String toString() {
        return "StandaloneAgentAdapter(" + this.aid.getName() + ")";
    }

    public void killAgent() {
        this.agent.killAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(IMessageEnvelope msgenv) {
        if (!msgenv.getTypeName().equals("fipa")) {
            throw new RuntimeException("Only type fipa currently supported: " + msgenv);
        }
        final Map message = msgenv.getMessage();
        String onto = (String)message.get("ontology");
        if (this.replywiths.contains(message.get("in-reply-to"))) {
            this.replywiths.remove(message.get("in-reply-to"));
            if (this.replywiths.isEmpty()) {
                this.wakeup();
            }
        } else if (onto != null && onto.startsWith("jadex.tools") && "request".equals(message.get("performative"))) {
            LinkedList linkedList = this.toolmsgqueue;
            synchronized (linkedList) {
                this.toolmsgqueue.addFirst(message);
            }
            this.wakeup();
        } else {
            this.agent.messageArrived(new FipaMessageAdapter(this.agent, message){

                public Object getRawValue(String name) {
                    return message.get(name);
                }

                public String getId() {
                    return (String)message.get("x-message-id");
                }
            });
        }
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public void timeEventOccurred() {
        if (this.state != null && !this.state.equals(AMSAgentDescription.STATE_INITIATED) && !this.state.equals(AMSAgentDescription.STATE_TERMINATED)) {
            this.agent.notifyDue();
        }
    }

    public IPlatform getPlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        if (this.agent == null) {
            return false;
        }
        if (!this.replywiths.isEmpty()) {
            return false;
        }
        Map toolmsg = null;
        LinkedList linkedList = this.toolmsgqueue;
        synchronized (linkedList) {
            if (!this.toolmsgqueue.isEmpty()) {
                toolmsg = (Map)this.toolmsgqueue.removeFirst();
            }
        }
        boolean executed = false;
        if (toolmsg != null) {
            this.handleToolMessage(toolmsg);
            executed = true;
        } else {
            try {
                executed = this.agent.executeAction();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.agent.getLogger().severe("Fatal error, agent '" + this.aid + "' will be removed.");
                this.cleanupAgent();
            }
        }
        return executed;
    }

    public void handleToolMessage(Map msg) {
        AgentIdentifier sender = (AgentIdentifier)msg.get("sender");
        AgentAction request = (AgentAction)Nuggets.objectFromXML((String)msg.get("content"));
        boolean processed = false;
        for (int i = 0; i < this.tooladapters.size(); ++i) {
            IToolAdapter adapter = (IToolAdapter)this.tooladapters.get(i);
            if (!adapter.getMessageClass().isInstance(request)) continue;
            try {
                adapter.handleToolRequest(sender, request, new StandaloneToolReply(msg, sender));
                processed = true;
                continue;
            }
            catch (RuntimeException e) {
                this.agent.getLogger().severe("Tool adapter " + adapter + "threw exception " + e);
                e.printStackTrace();
            }
        }
        if (!processed) {
            this.agent.getLogger().warning("No tool adapter to handle: " + request);
        }
    }

    static {
        $assertionsDisabled = !StandaloneAgentAdapter.class.desiredAssertionStatus();
    }

    private final class StandaloneToolReply
    implements IToolAdapter.IToolReply {
        private Map msg;
        private AgentIdentifier sender;

        private StandaloneToolReply(Map msg, AgentIdentifier sender) {
            this.msg = msg;
            this.sender = sender;
        }

        public void sendInform(Object content, boolean sync) {
            this.sendNative("inform", content, sync);
        }

        public void sendFailure(Object content, boolean sync) {
            this.sendNative("failure", content, sync);
        }

        protected void sendNative(String performative, Object content, boolean sync) {
            HashMap msg = SCollection.createHashMap();
            msg.put("sender", StandaloneAgentAdapter.this.aid);
            msg.put("receivers", new AgentIdentifier[]{this.sender});
            msg.put("performative", performative);
            msg.put("content", Nuggets.objectToXML(content));
            msg.put("in-reply-to", this.msg.get("reply-with"));
            msg.put("conversation-id", this.msg.get("conversation-id"));
            msg.put("language", "nuggets-xml");
            msg.put("ontology", this.msg.get("ontology"));
            msg.put("protocol", this.msg.get("protocol"));
            MessageEnvelope reply = new MessageEnvelope(msg, new AgentIdentifier[]{this.sender}, "fipa");
            if (sync) {
                String replyid = SFipa.createUniqueId(StandaloneAgentAdapter.this.aid.getName());
                StandaloneAgentAdapter.this.replywiths.add(replyid);
                msg.put("reply-with", replyid);
                StandaloneAgentAdapter.this.platform.getMessageService().sendMessage(reply);
                StandaloneAgentAdapter.this.platform.getTimerService().addEntry(new ITimedObject(this, replyid){
                    private final /* synthetic */ String val$replyid;
                    private final /* synthetic */ StandaloneToolReply this$1;
                    {
                        this.this$1 = this$1;
                        this.val$replyid = val$replyid;
                    }

                    public void timeEventOccurred() {
                        if (StandaloneToolReply.access$100((StandaloneToolReply)this.this$1).replywiths.remove(this.val$replyid)) {
                            StandaloneToolReply.access$100(this.this$1).wakeup();
                        }
                    }
                }, System.currentTimeMillis() + 10000L);
            } else {
                StandaloneAgentAdapter.this.platform.getMessageService().sendMessage(reply);
            }
        }

        static /* synthetic */ StandaloneAgentAdapter access$100(StandaloneToolReply x0) {
            return x0.StandaloneAgentAdapter.this;
        }
    }
}

