/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.standalone.IAMS;
import jadex.adapter.standalone.IDF;
import jadex.adapter.standalone.IMessageService;
import jadex.adapter.standalone.IPlatform;
import jadex.adapter.standalone.ITransport;
import jadex.adapter.standalone.MessageService;
import jadex.adapter.standalone.ams.AMS;
import jadex.adapter.standalone.df.DF;
import jadex.adapter.standalone.transport.localmtp.LocalTransport;
import jadex.adapter.standalone.transport.niotcpmtp.NIOTCPTransport;
import jadex.config.Configuration;
import jadex.parser.SParser;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import jadex.util.concurrent.AsyncExecutorService;
import jadex.util.concurrent.IExecutorService;
import jadex.util.concurrent.ITimerService;
import jadex.util.concurrent.ThreadPoolFactory;
import jadex.util.concurrent.TimerService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class Platform
implements IPlatform {
    public static final long MAX_SHUTDOWM_TIME = 3000L;
    public static final Set COMMAND_LINE_OPTIONS;
    public static final String CONFIGURATION = "conf";
    public static final String TRANSPORT = "transport";
    public static final Set COMMAND_LINE_FLAGS;
    public static final String NOGUI = "nogui";
    public static final String NOAMSAGENT = "noamsagent";
    public static final String NODFAGENT = "nodfagent";
    public static final String NOTRANSPORT = "notransport";
    public static final String AUTOSHUTDOWN = "autoshutdown";
    public static final String PLATFORMNAME = "platformname";
    public static final String FALLBACK_CONFIGURATION = "jadex/adapter/standalone/standalone_conf.properties";
    public static String PLATFORM_SHUTDOWN_TIME_CONFIG;
    public static final long starttime;
    public static long startup;
    protected ITimerService timer;
    protected IExecutorService executor;
    protected IAMS ams;
    protected IDF df;
    protected IMessageService msgservice;
    protected Logger logger;
    protected boolean shuttingdown;

    public Platform() {
        if (Configuration.getConfiguration().getProperty(PLATFORMNAME) == null) {
            Configuration.getConfiguration().setProperty(PLATFORMNAME, this.getName());
        }
        Configuration.getConfiguration().setProperty("starttime", "" + starttime);
        this.timer = this.createTimer();
        this.executor = this.createExecutorService();
        this.ams = this.createAMS();
        this.df = this.createDF();
        this.msgservice = this.createMessageService();
        this.logger = Logger.getLogger("Platform" + this);
        this.initializeTransports();
        try {
            Method meth = SReflect.getMethod(this.ams.getClass(), "addPropertyChangeListener", new Class[]{PropertyChangeListener.class});
            if (meth != null) {
                meth.invoke((Object)this.ams, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (Platform.this.ams.getAgentCount() == 0 && Configuration.getConfiguration().getProperty(Platform.AUTOSHUTDOWN) != null) {
                            Platform.this.shutdown();
                        }
                    }
                });
            }
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (Configuration.getConfiguration().getProperty(NOAMSAGENT) == null) {
            AgentIdentifier amsagent = this.ams.createAgent("ams", "jadex.adapter.standalone.ams.AMS", null, null);
            this.ams.startAgent(amsagent);
        }
        if (Configuration.getConfiguration().getProperty(NODFAGENT) == null) {
            AgentIdentifier dfagent = this.ams.createAgent("df", "jadex.adapter.standalone.df.DF", null, null);
            this.ams.startAgent(dfagent);
        }
    }

    public ITimerService getTimerService() {
        return this.timer;
    }

    public IExecutorService getExecutorService() {
        return this.executor;
    }

    public IAMS getAMS() {
        return this.ams;
    }

    public IDF getDF() {
        return this.df;
    }

    public IMessageService getMessageService() {
        return this.msgservice;
    }

    public boolean isShuttingDown() {
        return this.shuttingdown;
    }

    public String getName() {
        String ret = Configuration.getConfiguration().getProperty(PLATFORMNAME);
        if (ret == null) {
            try {
                InetAddress iaddr = InetAddress.getLocalHost();
                ret = iaddr.getHostName().toLowerCase();
            }
            catch (UnknownHostException e) {
                ret = "localhost";
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Platform platform = this;
        synchronized (platform) {
            if (this.shuttingdown) {
                return;
            }
            this.shuttingdown = true;
            AgentIdentifier[] agents = this.ams.getAgentIdentifiers();
            for (int i = 0; i < agents.length; ++i) {
                try {
                    this.ams.destroyAgent(agents[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
        new Thread(new Runnable(){

            public void run() {
                long shutdown = System.currentTimeMillis() + 3000L;
                try {
                    String shutdownprop = Configuration.getConfiguration().getProperty(PLATFORM_SHUTDOWN_TIME_CONFIG);
                    if (shutdownprop != null) {
                        shutdown = System.currentTimeMillis() + Long.parseLong(shutdownprop);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                while (Platform.this.ams.getAgentCount() > 0 && System.currentTimeMillis() < shutdown) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Platform.this.ams.shutdown();
                Platform.this.df.shutdown();
                Platform.this.msgservice.shutdown();
                Platform.this.timer.shutdown();
                ThreadPoolFactory.getThreadPool().dispose();
                System.exit(0);
            }
        }).start();
    }

    protected ITimerService createTimer() {
        return new TimerService();
    }

    protected IExecutorService createExecutorService() {
        return new AsyncExecutorService();
    }

    protected IAMS createAMS() {
        return new AMS(this);
    }

    protected IDF createDF() {
        return new DF();
    }

    protected IMessageService createMessageService() {
        return new MessageService(this, true);
    }

    protected void initializeTransports() {
        LocalTransport local = new LocalTransport();
        local.init(this, null);
        this.msgservice.addTransport(local);
        if (Configuration.getConfiguration().getProperty(NOTRANSPORT) == null) {
            String trspname = Configuration.getConfiguration().getProperty(TRANSPORT);
            if (trspname != null) {
                try {
                    String clsname = trspname;
                    int port = -1;
                    int sep = trspname.indexOf(":");
                    if (sep != -1) {
                        port = Integer.parseInt(clsname.substring(sep + 1));
                        clsname = clsname.substring(0, sep);
                    }
                    ITransport trsp = (ITransport)SReflect.findClass(clsname, null).newInstance();
                    HashMap settings = SCollection.createHashMap();
                    if (port != -1) {
                        settings.put("port", new Integer(port));
                    }
                    trsp.init(this, settings);
                    this.msgservice.addTransport(trsp);
                }
                catch (Throwable e) {
                    System.out.println("Could not initialize transport: " + e);
                }
            } else {
                try {
                    NIOTCPTransport niotcp = new NIOTCPTransport();
                    HashMap settings = SCollection.createHashMap();
                    settings.put("port", new Integer(5678));
                    niotcp.init(this, settings);
                    this.msgservice.addTransport(niotcp);
                }
                catch (Exception e) {
                    System.out.println("Could not initialize transport: " + e);
                }
            }
        }
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        args = Platform.parseOptions(args, props);
        String conffile = props.getProperty(CONFIGURATION);
        if (conffile != null) {
            System.setProperty(Configuration.JADEX_CONFIGURATION, conffile);
        } else {
            Configuration.setFallbackConfiguration(FALLBACK_CONFIGURATION);
        }
        String[] propkeys = props.keySet().toArray(new String[props.size()]);
        for (int i = 0; i < propkeys.length; ++i) {
            Configuration.getConfiguration().setProperty(propkeys[i], props.getProperty(propkeys[i]));
        }
        Platform platform = new Platform();
        if (props.get(NOGUI) == null) {
            AgentIdentifier jcc = platform.getAMS().createAgent("jcc", "jadex.tools.jcc.JCC", null, null);
            platform.getAMS().startAgent(jcc);
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                int index = args[i].indexOf(":");
                if (index != -1) {
                    String name = args[i].substring(0, index);
                    String model = args[i].substring(index + 1, args[i].length());
                    String config = null;
                    Object aargs = null;
                    HashMap argsmap = null;
                    index = model.indexOf("(");
                    if (index != -1) {
                        String tmp;
                        if (model.lastIndexOf(")") != model.length() - 1) {
                            throw new RuntimeException("Syntax-Error. Missing ')' at the end of agent's (command-line) argument: " + model);
                        }
                        String agentargs = model.substring(index + 1, model.length() - 1);
                        model = model.substring(0, index);
                        StringTokenizer stok = new StringTokenizer(agentargs, ",");
                        if (stok.hasMoreTokens() && !(tmp = stok.nextToken()).equals("null")) {
                            config = tmp;
                        }
                        argsmap = SCollection.createHashMap();
                        while (stok.hasMoreTokens()) {
                            tmp = stok.nextToken();
                            int idx = tmp.indexOf("=");
                            if (idx == -1) continue;
                            String argname = tmp.substring(0, idx);
                            String argvalstr = tmp.substring(idx + 1);
                            Object argval = null;
                            try {
                                argval = SParser.evaluateExpression(argvalstr, null, null);
                            }
                            catch (Exception e) {
                                System.out.println("Cannot evaluate argument: " + argname + ". Reason: " + e.getMessage());
                            }
                            argsmap.put(argname, argval);
                        }
                    }
                    AgentIdentifier agent = platform.getAMS().createAgent(name, model, config, argsmap);
                    platform.getAMS().startAgent(agent);
                    continue;
                }
                System.out.println("Illegal agent specification: " + args[i]);
                System.out.println("Syntax: <name>:<model> ... e.g. hello:jadex.examples.helloworld.HelloWorld");
                System.out.println("Syntax: <name>:<model>(<initialstate>,<arg1>,...,<argN>) ... \ne.g. hello:jadex.examples.helloworld.HelloWorld(default,HEY!)");
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        startup = System.currentTimeMillis() - starttime;
        platform.logger.info("Platform startup time: " + startup + " ms.");
    }

    protected static String[] parseOptions(String[] args, Properties props) {
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            if (COMMAND_LINE_OPTIONS.contains(args[i])) {
                props.setProperty(args[i++].substring(1), args[i++]);
                continue;
            }
            if (COMMAND_LINE_FLAGS.contains(args[i])) {
                props.setProperty(args[i++].substring(1), "true");
                continue;
            }
            System.out.println("Argument could not be understood: " + args[i++]);
        }
        String[] ret = new String[args.length - i];
        if (ret.length > 0) {
            System.arraycopy(args, i, ret, 0, ret.length);
        }
        return ret;
    }

    static {
        PLATFORM_SHUTDOWN_TIME_CONFIG = "platform_shutdown_time";
        starttime = System.currentTimeMillis();
        COMMAND_LINE_OPTIONS = SCollection.createHashSet();
        COMMAND_LINE_OPTIONS.add("-platformname");
        COMMAND_LINE_OPTIONS.add("-conf");
        COMMAND_LINE_OPTIONS.add("-transport");
        COMMAND_LINE_FLAGS = SCollection.createHashSet();
        COMMAND_LINE_FLAGS.add("-nogui");
        COMMAND_LINE_FLAGS.add("-noamsagent");
        COMMAND_LINE_FLAGS.add("-nodfagent");
        COMMAND_LINE_FLAGS.add("-notransport");
        COMMAND_LINE_FLAGS.add("-autoshutdown");
    }
}

