/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.standalone;

import jadex.adapter.IAgentAdapter;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.standalone.IMessageEnvelope;
import jadex.adapter.standalone.IMessageService;
import jadex.adapter.standalone.IPlatform;
import jadex.adapter.standalone.ITransport;
import jadex.adapter.standalone.StandaloneAgentAdapter;
import jadex.runtime.MessageFailureException;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import jadex.util.concurrent.AsyncManager;
import jadex.util.concurrent.ICommand;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MessageService
implements IMessageService {
    protected IPlatform platform;
    protected List transports;
    private String[] addresses;
    protected boolean async;
    protected AsyncManager aman;
    protected ICommand sendmsg;
    protected Logger logger;

    protected MessageService(IPlatform platform, boolean async) {
        this.platform = platform;
        this.transports = SCollection.createArrayList();
        this.aman = new AsyncManager(async);
        this.sendmsg = new ICommand(){

            public void execute(Object args) {
                MessageService.this.internalSendMessage((IMessageEnvelope)args);
            }
        };
        this.logger = Logger.getLogger("MessageService" + this);
    }

    public void sendMessage(IMessageEnvelope message) {
        this.aman.execute(this.sendmsg, message);
    }

    public synchronized void deliverMessage(IMessageEnvelope message) {
        AgentIdentifier[] receivers = message.getReceivers();
        for (int i = 0; i < receivers.length; ++i) {
            IAgentAdapter agent = this.platform.getAMS().getAgentAdapter(receivers[i]);
            if (agent != null) {
                ((StandaloneAgentAdapter)agent).receiveMessage(message);
                continue;
            }
            this.logger.warning("Message could not be delivered to sender: " + message);
        }
    }

    public void addTransport(ITransport transport) {
        this.transports.add(transport);
        this.addresses = null;
    }

    public void removeTransport(ITransport transport) {
        this.transports.remove(transport);
        transport.shutdown();
        this.addresses = null;
    }

    public synchronized void changeTransportPosition(boolean up, ITransport transport) {
        int index = this.transports.indexOf(transport);
        if (up && index > 0) {
            ITransport temptrans = (ITransport)this.transports.get(index - 1);
            this.transports.set(index - 1, transport);
            this.transports.set(index, temptrans);
        } else if (index != -1 && index < this.transports.size() - 1) {
            ITransport temptrans = (ITransport)this.transports.get(index + 1);
            this.transports.set(index + 1, transport);
            this.transports.set(index, temptrans);
        } else {
            throw new RuntimeException("Cannot change transport position from " + index + (up ? " up" : " down"));
        }
    }

    public String[] getAddresses() {
        if (this.addresses == null) {
            ITransport[] trans = this.transports.toArray(new ITransport[this.transports.size()]);
            ArrayList<String> addrs = new ArrayList<String>();
            for (int i = 0; i < trans.length; ++i) {
                String[] traddrs = trans[i].getAddresses();
                for (int j = 0; j < traddrs.length; ++j) {
                    addrs.add(traddrs[j]);
                }
            }
            this.addresses = addrs.toArray(new String[addrs.size()]);
        }
        return this.addresses;
    }

    public ITransport[] getTransports() {
        ITransport[] transportsArray = new ITransport[this.transports.size()];
        return this.transports.toArray(transportsArray);
    }

    public void shutdown() {
        for (int i = 0; i < this.transports.size(); ++i) {
            ((ITransport)this.transports.get(i)).shutdown();
        }
    }

    protected void internalSendMessage(IMessageEnvelope message) {
        AgentIdentifier[] receivers = message.getReceivers();
        if (receivers.length == 0) {
            throw new MessageFailureException((Object)message, "No receiver specified");
        }
        for (int i = 0; i < receivers.length; ++i) {
            if (receivers[i] != null) continue;
            throw new MessageFailureException((Object)message, "A receiver nulls");
        }
        ITransport[] trans = this.transports.toArray(new ITransport[this.transports.size()]);
        for (int i = 0; i < trans.length; ++i) {
            try {
                message.setReceivers(receivers);
                receivers = trans[i].sendMessage(message);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (receivers.length > 0) {
            this.logger.warning("Message could not be delivered to (all) receivers: " + SUtil.arrayToString(receivers));
        }
    }
}

