/*
 * Decompiled with CFR 0.152.
 */
package jadex.tutorial;

import jadex.runtime.AgentDeathException;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerPlanG1
extends Plan
implements Runnable {
    protected ServerSocket server;

    public ServerPlanG1(int port) {
        try {
            this.server = new ServerSocket(port);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.getLogger().info("Created: " + this.server);
    }

    public void body() {
        new Thread(this).start();
        this.waitFor(IFilter.NEVER);
    }

    public void aborted() {
        try {
            this.getLogger().info("Closing: " + this.server);
            this.server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.getExternalAccess().getLogger().info("Created: " + Thread.currentThread());
        try {
            while (true) {
                Socket client = this.server.accept();
                IGoal goal = this.getExternalAccess().getGoalbase().createGoal("translate");
                goal.getParameter("client").setValue((Object)client);
                this.getExternalAccess().getGoalbase().dispatchTopLevelGoal(goal);
            }
        }
        catch (IOException e) {
            this.getExternalAccess().getLogger().info("Exited: " + Thread.currentThread());
        }
        catch (AgentDeathException e) {
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

